/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoXliffUtilSplit]̃NX
 */
package blanco.xliff.util.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.xliff.util.task.valueobject.BlancoXliffUtilSplitProcessInput;

/**
 * Apache Ant^XN [BlancoXliffUtilSplit]̃NXB
 *
 * [XLIFFΉc[] w肳ꂽxlifft@Cw茏ɕ܂B<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.xliff.util.task]BlancoXliffUtilSplitBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancoxliffutilsplit&quot; classname=&quot;blanco.xliff.util.task.BlancoXliffUtilSplitTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoXliffUtilSplitTask extends Task {
    /**
     * [XLIFFΉc[] w肳ꂽxlifft@Cw茏ɕ܂B
     */
    protected BlancoXliffUtilSplitProcessInput fInput = new BlancoXliffUtilSplitProcessInput();

    /**
     * [XLIFFΉc[] w肳ꂽxlifft@Cw茏ɕ܂B
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * [XLIFFΉc[] w肳ꂽxlifft@Cw茏ɕ܂B
     */
    protected boolean fIsFieldSourcefileProcessed = false;

    /**
     * [XLIFFΉc[] w肳ꂽxlifft@Cw茏ɕ܂B
     */
    protected boolean fIsFieldCountProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * XLIFF (*.xlf) t@Co͂fBNgB<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * XLIFF (*.xlf) t@Co͂fBNgB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[sourcefile]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * ͑Ώۂ XLIFF (*.xlf) t@CB<br>
     *
     * @param arg Zbgl
     */
    public void setSourcefile(final String arg) {
        fInput.setSourcefile(arg);
        fIsFieldSourcefileProcessed = true;
    }

    /**
     * Ant^XN[sourcefile]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * ͑Ώۂ XLIFF (*.xlf) t@CB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getSourcefile() {
        return fInput.getSourcefile();
    }

    /**
     * Ant^XN[count]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * ۂ trans-unit ̌B<br>
     *
     * @param arg Zbgl
     */
    public void setCount(final String arg) {
        try {
            fInput.setCount(Integer.parseInt(arg));
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException("Ant^XN[count]Agr[gɗ^ꂽl̐l͂Ɏs܂B" + e.toString());
        }
        fIsFieldCountProcessed = true;
    }

    /**
     * Ant^XN[count]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * ۂ trans-unit ̌B<br>
     * ftHgl[50]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getCount() {
        return String.valueOf(fInput.getCount());
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoXliffUtilSplitTask begin.");

        // ڔԍ[1]AAgr[g[targetdir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldTargetdirProcessed == false) {
            throw new BuildException("K{Agr[g[targetdir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[sourcefile]͕K{͂łB̓`FbNs܂B
        if (fIsFieldSourcefileProcessed == false) {
            throw new BuildException("K{Agr[g[sourcefile]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- sourcefile:[" + getSourcefile() + "]");
            System.out.println("- count:[" + getCount() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoXliffUtilSplitProcessC^tF[X blanco.xliff.util.taskpbP[W BlancoXliffUtilSplitProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoXliffUtilSplitProcess proc = new BlancoXliffUtilSplitProcessImpl();
            if (proc.execute(fInput) != BlancoXliffUtilSplitBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
