/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.JARorFolderFileFilter;
import org.omegat.filters2.master.OneFilter;
import org.omegat.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginUtils {
    private static List<List<Object>> plugins;
    private static List<List<Object>> old_plugins;
    private static ClassLoader plugins_cl;

    private PluginUtils() {
    }

    public static void loadPlugins() {
        plugins = new ArrayList<List<Object>>();
        File file = new File("plugins/");
        if (file.exists() && file.isDirectory()) {
            PluginUtils.loadPluginsFrom(file);
        }
    }

    private static void loadPluginsFrom(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles(new JARorFolderFileFilter())) {
            if (file2.isFile()) {
                try {
                    URL uRL = file2.toURL();
                    PluginUtils.loadOnePlugin(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    Log.log("Couldn't access local file system to get '" + file2 + "' !");
                }
                catch (IOException iOException) {
                    Log.log("Couldn't load plugin JAR '" + file2 + "' !");
                }
                continue;
            }
            PluginUtils.loadPluginsFrom(file2);
        }
    }

    private static void loadOnePlugin(URL uRL) throws IOException {
        JarFile jarFile = new JarFile(uRL.getFile());
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue("OmegaT-Plugin") == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(uRL);
        Map<String, Attributes> map = manifest.getEntries();
        for (String string : map.keySet()) {
            Attributes attributes2 = map.get(string);
            String string2 = attributes2.getValue("Name");
            String string3 = attributes2.getValue("OmegaT-Filter");
            if (string3 == null || !string3.equals("true")) continue;
            arrayList.add(string);
            try {
                URLClassLoader.newInstance(new URL[]{uRL}).loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getLocalizedMessage());
            }
        }
        if (arrayList.size() > 1) {
            plugins.add(arrayList);
        }
    }

    public static AbstractFilter instantiateFilter(OneFilter oneFilter) throws TranslationException {
        AbstractFilter abstractFilter = null;
        try {
            Class<?> clazz;
            Object object;
            if (oneFilter.isFromPlugin()) {
                object = PluginUtils.getPluginsClassloader();
                clazz = ((ClassLoader)object).loadClass(oneFilter.getClassName());
            } else {
                clazz = Class.forName(oneFilter.getClassName());
            }
            object = clazz.getConstructor(null);
            abstractFilter = (AbstractFilter)((Constructor)object).newInstance(null);
            abstractFilter.setOptions(oneFilter.getOptions());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TranslationException(classNotFoundException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TranslationException(noSuchMethodException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new TranslationException(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TranslationException(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TranslationException(invocationTargetException.getCause().toString());
        }
        return abstractFilter;
    }

    public static ClassLoader getPluginsClassloader() {
        if (!((Object)plugins).equals(old_plugins)) {
            ArrayList<URL> arrayList = new ArrayList<URL>(plugins.size());
            for (int i = 0; i < plugins.size(); ++i) {
                List<Object> list = plugins.get(i);
                URL uRL = (URL)list.get(0);
                arrayList.add(uRL);
            }
            plugins_cl = new URLClassLoader(arrayList.toArray(new URL[plugins.size()]));
            old_plugins = new ArrayList<List<Object>>();
            old_plugins.addAll(plugins);
        }
        return plugins_cl;
    }

    public static List<List<Object>> getPlugins() {
        return plugins;
    }

    static {
        old_plugins = null;
        plugins_cl = null;
    }
}

