/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3;

import org.omegat.filters3.Attributes;
import org.omegat.filters3.Element;

public abstract class Tag
implements Element {
    public static final int TYPE_BEGIN = 1;
    public static final int TYPE_END = 2;
    public static final int TYPE_ALONE = 3;
    private String tag;
    private String shortcut;
    private int type;
    private Attributes attributes;
    private int index;

    public String getTag() {
        return this.tag;
    }

    public String getShortcut() {
        if (this.shortcut != null) {
            return this.shortcut;
        }
        return Character.toString(this.getTag().charAt(0));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public Tag(String string, String string2, int n, Attributes attributes) {
        this.tag = string;
        this.shortcut = string2;
        this.type = n;
        this.attributes = attributes;
    }

    public String toTMX() {
        String string;
        switch (this.getType()) {
            case 1: {
                string = "bpt";
                break;
            }
            case 2: {
                string = "ept";
                break;
            }
            case 3: {
                string = "ph";
                break;
            }
            default: {
                throw new RuntimeException("Shouldn't hapen!");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append(" i=\"");
        stringBuffer.append(this.getIndex());
        stringBuffer.append("\">");
        stringBuffer.append(this.toPartialTMX());
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    protected String toPartialTMX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&amp;lt;");
        if (2 == this.getType()) {
            stringBuffer.append("/");
        }
        stringBuffer.append(this.getTag());
        stringBuffer.append(this.getAttributes().toString());
        if (3 == this.getType()) {
            stringBuffer.append("/");
        }
        stringBuffer.append("&amp;gt;");
        return stringBuffer.toString();
    }

    public String toShortcut() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        if (2 == this.getType()) {
            stringBuffer.append("/");
        }
        stringBuffer.append(this.getShortcut());
        stringBuffer.append(this.getIndex());
        if (3 == this.getType()) {
            stringBuffer.append("/");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public abstract String toOriginal();
}

