import java.io.File;
import java.util.List;

import junit.framework.TestCase;

import org.omegat.core.data.StringEntry;
import org.omegat.gui.glossary.GlossaryEntry;

import blanco.omegat.util.glossary.MyGlossaryManager;

public class GlossaryTest extends TestCase {
    public void test() throws Exception {
        final MyGlossaryManager gm = new MyGlossaryManager();
        gm.loadGlossaryFiles(new File("glossary"));

        final StringEntry tuEntry = new StringEntry("This is source text.");

        List<GlossaryEntry> glossryList = gm.getGlossary(tuEntry);

        System.out.println(glossryList.size()
                + "̗pꂪ݂܂B");
        for (int i = 0; i <glossryList.size(); i++) {
            GlossaryEntry glossaryEntry = glossryList.get(i);
            System.out.println("------------------------------------");
            System.out.println((i + 1) + "");
            System.out.println(glossaryEntry.getSrcText());
            System.out.println(glossaryEntry.getLocText());
            System.out.println(glossaryEntry.getCommentText());
        }
        System.out.println("------------------------------------");
        System.out.println("");
    }
}
