/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.html.formatter.spec.stringgroup;

/**
 * HTML̗vfɂĂ̎dl̃^Cv킷o[IuWFNgłB̏̋N: http://www.w3.org/TR/1999/REC-html401-19991224/index/elements.html
 */
public class BlancoHtmlElementSpecTypeStringGroup {
    /**
     * No.1 :(S) dl̎ɓɋLڂ̂Ȃ́B
     */
    public static final int DEFAULT = 1;

    /**
     * No.2 :(Start Tag)(End Tag) Start Tag  End Tag ɂăIvVł́B
     */
    public static final int OPTIONAL = 2;

    /**
     * No.3 :(End Tag) End Tag ɂėpւẮB
     */
    public static final int FORBIDDEN = 3;

    /**
     * No.4 :̃Ggł́B&lt;BR&gt;ȂǁB
     */
    public static final int EMPTY = 4;

    /**
     * No.5 :gp񐄏̂́B
     */
    public static final int DEPRECATED = 5;

    /**
     * No.6 :(DTD) Loose DTD ̂́B
     */
    public static final int LOOSE_DTD = 6;

    /**
     * No.7 :(DTD) Frameset DTD ̂́B
     */
    public static final int FRAMESET_DTD = 7;

    /**
     * `BO[vȊO̕܂͒萔`̂́B
     */
    public static final int NOT_DEFINED = -1;

    /**
     * O[vɊ܂܂镶ł邩ǂ𔻒肵܂B
     *
     * @param argCheck `FbNsB
     * @return O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB
     */
    public boolean match(final String argCheck) {
        // No.1
        // :(S) dl̎ɓɋLڂ̂Ȃ́B
        if ("-".equals(argCheck)) {
            return true;
        }
        // No.2
        // :(Start Tag)(End Tag) Start Tag  End Tag ɂăIvVł́B
        if ("Optional".equals(argCheck)) {
            return true;
        }
        // No.3
        // :(End Tag) End Tag ɂėpւẮB
        if ("Forbidden".equals(argCheck)) {
            return true;
        }
        // No.4
        // :̃Ggł́B<BR>ȂǁB
        if ("Empty".equals(argCheck)) {
            return true;
        }
        // No.5
        // :gp񐄏̂́B
        if ("Deprecated".equals(argCheck)) {
            return true;
        }
        // No.6
        // :(DTD) Loose DTD ̂́B
        if ("Loose DTD".equals(argCheck)) {
            return true;
        }
        // No.7
        // :(DTD) Frameset DTD ̂́B
        if ("Frameset DTD".equals(argCheck)) {
            return true;
        }
        return false;
    }

    /**
     * O[vɊ܂܂镶ł邩ǂA啶ʂ肵܂B
     *
     * @param argCheck `FbNsB
     * @return O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB
     */
    public boolean matchIgnoreCase(final String argCheck) {
        // No.1
        // :(S) dl̎ɓɋLڂ̂Ȃ́B
        if ("-".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.2
        // :(Start Tag)(End Tag) Start Tag  End Tag ɂăIvVł́B
        if ("Optional".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.3
        // :(End Tag) End Tag ɂėpւẮB
        if ("Forbidden".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.4
        // :̃Ggł́B<BR>ȂǁB
        if ("Empty".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.5
        // :gp񐄏̂́B
        if ("Deprecated".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.6
        // :(DTD) Loose DTD ̂́B
        if ("Loose DTD".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.7
        // :(DTD) Frameset DTD ̂́B
        if ("Frameset DTD".equalsIgnoreCase(argCheck)) {
            return true;
        }
        return false;
    }

    /**
     * 񂩂萔ɕϊ܂B
     *
     * 萔`̏ꍇ ^ꂽ񂪕O[vȌꍇɂ NOT_DEFINED ߂܂B
     *
     * @param argCheck ϊsB
     * @return 萔ɕϊ̒lB
     */
    public int convertToInt(final String argCheck) {
        // No.1
        // :(S) dl̎ɓɋLڂ̂Ȃ́B
        if ("-".equals(argCheck)) {
            return DEFAULT;
        }
        // No.2
        // :(Start Tag)(End Tag) Start Tag  End Tag ɂăIvVł́B
        if ("Optional".equals(argCheck)) {
            return OPTIONAL;
        }
        // No.3
        // :(End Tag) End Tag ɂėpւẮB
        if ("Forbidden".equals(argCheck)) {
            return FORBIDDEN;
        }
        // No.4
        // :̃Ggł́B<BR>ȂǁB
        if ("Empty".equals(argCheck)) {
            return EMPTY;
        }
        // No.5
        // :gp񐄏̂́B
        if ("Deprecated".equals(argCheck)) {
            return DEPRECATED;
        }
        // No.6
        // :(DTD) Loose DTD ̂́B
        if ("Loose DTD".equals(argCheck)) {
            return LOOSE_DTD;
        }
        // No.7
        // :(DTD) Frameset DTD ̂́B
        if ("Frameset DTD".equals(argCheck)) {
            return FRAMESET_DTD;
        }

        // Y萔܂łB
        return NOT_DEFINED;
    }

    /**
     * 萔當ɕϊ܂B
     *
     * 萔ƑΉÂɕϊ܂B
     *
     * @param argCheck ϊs萔B
     * @return ɕϊ̒lBNOT_DEFINED̏ꍇɂ͒0̕B
     */
    public String convertToString(final int argCheck) {
        // No.1
        // :(S) dl̎ɓɋLڂ̂Ȃ́B
        if (argCheck == DEFAULT) {
            return "-";
        }
        // No.2
        // :(Start Tag)(End Tag) Start Tag  End Tag ɂăIvVł́B
        if (argCheck == OPTIONAL) {
            return "Optional";
        }
        // No.3
        // :(End Tag) End Tag ɂėpւẮB
        if (argCheck == FORBIDDEN) {
            return "Forbidden";
        }
        // No.4
        // :̃Ggł́B<BR>ȂǁB
        if (argCheck == EMPTY) {
            return "Empty";
        }
        // No.5
        // :gp񐄏̂́B
        if (argCheck == DEPRECATED) {
            return "Deprecated";
        }
        // No.6
        // :(DTD) Loose DTD ̂́B
        if (argCheck == LOOSE_DTD) {
            return "Loose DTD";
        }
        // No.7
        // :(DTD) Frameset DTD ̂́B
        if (argCheck == FRAMESET_DTD) {
            return "Frameset DTD";
        }
        // `B
        if (argCheck == NOT_DEFINED) {
            return "";
        }

        // ɂY܂łB
        throw new IllegalArgumentException("^ꂽl(" + argCheck + ")͕O[v[BlancoHtmlElementSpecType]ł͒`ȂlłB");
    }
}
