/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.formatter.util;

import java.util.ArrayList;
import java.util.List;

import blanco.html.formatter.spec.stringgroup.BlancoHtmlElementSpecTypeStringGroup;
import blanco.html.formatter.spec.valueobject.BlancoHtmlElementSpec;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEvent;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventCharacters;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventComments;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventEndDocument;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventEndElement;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventStartDocument;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventStartElement;
import blanco.html.parser.util.BlancoHtmlParserUtil;

public class BlancoHtmlFormatterUtil {
    /**
     * vfXg𒲐B
     * 
     * ^ÕyA`FbNB⊮B deapth̎{B
     * 
     * @param eventList
     */
    public static final List<BlancoHtmlEvent> trimWhiteSpaces(
            final List<BlancoHtmlEvent> argOriginalEventList) {
        final List<BlancoHtmlEvent> eventList = new ArrayList<BlancoHtmlEvent>();
        for (BlancoHtmlEvent event : argOriginalEventList) {
            eventList.add(event);
        }

        for (int index = 0; index < eventList.size(); index++) {
            final BlancoHtmlEvent look = eventList.get(index);
            if (look instanceof BlancoHtmlEventStartDocument) {
            } else if (look instanceof BlancoHtmlEventEndDocument) {
            } else if (look instanceof BlancoHtmlEventStartElement) {
            } else if (look instanceof BlancoHtmlEventEndElement) {
            } else if (look instanceof BlancoHtmlEventCharacters) {
                // TODO m̖B̃^Oł̓zCgXy[XĂ͂߂łB
                // TODO ЂƂ͎cAȂǁB
                final BlancoHtmlEventCharacters event = (BlancoHtmlEventCharacters) look;
                if (isWhiteSpaces(event.getCharacters())) {
                    eventList.remove(index--);
                }
            } else if (look instanceof BlancoHtmlEventComments) {
            }
        }

        return eventList;
    }

    /**
     * vfXg𒲐B
     * 
     * ^ÕyA`FbNB⊮B deapth̎{B
     * 
     * @param eventList
     */
    public static final List<BlancoHtmlEvent> format(
            final List<BlancoHtmlEvent> argOriginalEventList) {
        final List<BlancoHtmlEvent> eventList = new ArrayList<BlancoHtmlEvent>();
        for (BlancoHtmlEvent event : argOriginalEventList) {
            eventList.add(event);
        }

        int deapth = -2;

        final List<BlancoHtmlElementSpec> specList = BlancoHtmlElementSpecUtil
                .getSpecListInstance();

        boolean isFirstElement = true;
        for (int index = 0; index < eventList.size(); index++) {
            final BlancoHtmlEvent look = eventList.get(index);
            if (look instanceof BlancoHtmlEventStartDocument) {
                deapth++;
            } else if (look instanceof BlancoHtmlEventEndDocument) {
                deapth--;
            } else if (look instanceof BlancoHtmlEventStartElement) {
                final BlancoHtmlEventStartElement event = (BlancoHtmlEventStartElement) look;

                deapth++;

                if (isFirstElement) {
                    isFirstElement = false;
                } else {
                    // TODO ̃^O܂͓^Oł́As}͕sK
                    final BlancoHtmlEventCharacters characters = new BlancoHtmlEventCharacters();
                    characters.setCharacters(getSpaces(deapth));
                    eventList.add(index++, characters);
                }

                for (BlancoHtmlElementSpec spec : specList) {
                    if (spec.getName().toUpperCase().equals(
                            event.getName().toUpperCase())) {
                        if (spec.getEmpty() == BlancoHtmlElementSpecTypeStringGroup.EMPTY) {
                            deapth--;
                            break;
                        }
                    }
                }
            } else if (look instanceof BlancoHtmlEventEndElement) {
                final BlancoHtmlEventEndElement event = (BlancoHtmlEventEndElement) look;

                // TODO ̃^Oł́As}͕sK
                // TODO Ƃ a Ƃ p ƂB
                final BlancoHtmlEventCharacters characters = new BlancoHtmlEventCharacters();
                characters.setCharacters(getSpaces(deapth));
                eventList.add(index++, characters);

                deapth--;
            } else if (look instanceof BlancoHtmlEventCharacters) {
            } else if (look instanceof BlancoHtmlEventComments) {
                final BlancoHtmlEventComments event = (BlancoHtmlEventComments) look;

                // TODO ̃^Oł́As}͕sK
                // TODO ƂARgsĂ悢̂ǂsB
                final BlancoHtmlEventCharacters characters = new BlancoHtmlEventCharacters();
                characters.setCharacters(getSpaces(deapth));
                eventList.add(index++, characters);
            }
        }

        return eventList;
    }

    protected static String getSpaces(int length) {
        final StringBuffer buf = new StringBuffer();
        // TODO ŉsĂ悢̂ǂsB܂s \n ŗǂ̂?
        buf.append('\n');
        for (int index = 1; index < length; index++) {
            buf.append(' ');
        }

        return buf.toString();
    }

    protected static boolean isWhiteSpaces(final String arg) {
        for (int index = 0; index < arg.length(); index++) {
            if (BlancoHtmlParserUtil.isWhiteSpace(arg.charAt(index)) == false) {
                return false;
            }
        }
        return true;
    }
}
