/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.normalizer.parser.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import blanco.html.normalizer.parser.valueobject.BlancoHtmlEvent;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventCharacters;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventComments;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventEndDocument;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventEndElement;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventStartDocument;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventStartElement;
import blanco.html.parser.BlancoHtmlContentHandler;
import blanco.html.parser.valueobject.BlancoHtmlAttribute;

/**
 * HTML p[XāAHTMLCxg擾܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoHtmlEventParserContentHandler implements
        BlancoHtmlContentHandler {
    /**
     * HTMLCxgXgB
     */
    protected List<BlancoHtmlEvent> fEventList = new ArrayList<BlancoHtmlEvent>();

    /**
     * p[Xʂ̃CxgXg擾܂B
     * 
     * ȂAŖ߂̂́ACxgû܂܁vłB IvV̏I^OȂǂ͎̒{Ă܂B
     * 
     * @return CxgXgB
     */
    public List<BlancoHtmlEvent> getEventList() {
        return fEventList;
    }

    /**
     * hLg̊JnB
     * 
     * @throws IOException
     *             o͗OꍇB
     */
    public void startDocument() throws IOException {
        final BlancoHtmlEventStartDocument event = new BlancoHtmlEventStartDocument();
        fEventList.add(event);
    }

    /**
     * hLg̏IB
     * 
     * @throws IOException
     *             o͗OꍇB
     */
    public void endDocument() throws IOException {
        final BlancoHtmlEventEndDocument event = new BlancoHtmlEventEndDocument();
        fEventList.add(event);
    }

    /**
     * vf̊JnB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     * @param attrs
     *            ̃XgB
     */
    public void startElement(final String name,
            final List<BlancoHtmlAttribute> attrs) throws IOException {
        final BlancoHtmlEventStartElement event = new BlancoHtmlEventStartElement();
        fEventList.add(event);
        event.setName(name);
        event.setAttrs(attrs);
    }

    /**
     * vf̏IB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     */
    public void endElement(final String name) throws IOException {
        final BlancoHtmlEventEndElement event = new BlancoHtmlEventEndElement();
        fEventList.add(event);
        event.setName(name);
    }

    /**
     * BQƂȂǂ̏ĂȂ񂪁û܂܁v߂܂B
     * 
     * @param argCharacters
     *            BQƂȂǂ́û܂܁vi[܂B
     */
    public void characters(final String argCharacters) throws IOException {
        final BlancoHtmlEventCharacters event = new BlancoHtmlEventCharacters();
        fEventList.add(event);
        event.setCharacters(argCharacters);
    }

    /**
     * RgB̂܂܂̕񂪖߂܂B
     * 
     * @param argComments
     *            RgBû܂܁vi[܂B
     * @param argType
     *            Rǧ`B0:!A1:%
     */
    public void comments(final String argComments, final int argType)
            throws IOException {
        final BlancoHtmlEventComments event = new BlancoHtmlEventComments();
        fEventList.add(event);
        event.setComments(argComments);
        event.setType(argType);
    }
}
