/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.normalizer.parser.helper;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;

import blanco.html.parser.BlancoHtmlContentHandler;
import blanco.html.parser.BlancoHtmlContentSerializer;
import blanco.html.parser.valueobject.BlancoHtmlAttribute;

/**
 * NI[g𐳏퉻邽߂̃nh[B
 * 
 * 퉻ʂ̓C^[ɃVACY܂B
 */
public class BlancoHtmlNormalizeQuoteContentHandler implements
        BlancoHtmlContentHandler {
    /**
     * o͐ƂȂVACU[B
     */
    protected final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();

    /**
     * C^[ݒ肵܂B
     * 
     * @param writer
     *            C^[B
     */
    public void setWriter(final BufferedWriter writer) {
        serializer.setWriter(writer);
    }

    /**
     * C^[擾܂B
     * 
     * @return C^[B
     */
    public BufferedWriter getWriter() {
        return serializer.getWriter();
    }

    /**
     * hLg̊JnB
     * 
     * @throws IOException
     *             o͗OꍇB
     */
    public void startDocument() throws IOException {
        serializer.startDocument();
    }

    /**
     * hLg̏IB
     * 
     * @throws IOException
     *             o͗OꍇB
     */
    public void endDocument() throws IOException {
        serializer.endDocument();
    }

    /**
     * vf̊JnB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     * @param attrs
     *            ̃XgB
     */
    public void startElement(final String name,
            final List<BlancoHtmlAttribute> attrs) throws IOException {
        for (BlancoHtmlAttribute attr : attrs) {
            if (attr.getQuote() == 0) {
                // NI[gȂꍇɂ̓NI[gZbgB
                // TODO Agr[gɃNI[gꍇ̏B
                attr.setQuote(2);
            }
        }
        serializer.startElement(name, attrs);
    }

    /**
     * vf̏IB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     */
    public void endElement(final String name) throws IOException {
        serializer.endElement(name);
    }

    /**
     * BQƂȂǂ̏ĂȂ񂪁û܂܁v߂܂B
     * 
     * @param argCharacters
     *            BQƂȂǂ́û܂܁vi[܂B
     */
    public void characters(final String argCharacters) throws IOException {
        serializer.characters(argCharacters);
    }

    /**
     * RgB̂܂܂̕񂪖߂܂B
     * 
     * @param argComments
     *            RgBû܂܁vi[܂B
     * @param argType
     *            Rǧ`B0:!A1:%
     */
    public void comments(final String argComments, final int argType)
            throws IOException {
        serializer.comments(argComments, argType);
    }
}
