/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.valueobject.task;

import java.io.IOException;

import blanco.valueobject.task.valueobject.BlancoValueObjectBatchProcessInput;

/**
 * ob`NX [BlancoValueObjectBatchProcess]̒ېeNXB̃NX̓pbP[WANZXɌ肳Ă܂ (publicNXł͂܂)B
 *
 * ̃NXp [blanco.valueobject.task]pbP[W[BlancoValueObjectBatchProcess]NX쐬Ďۂ̃ob`ĂB<br>
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.valueobject.task.BlancoValueObjectBatchProcess -help
 * </code>
 */
abstract class AbstractBlancoValueObjectBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // ̉ӏŃRpCG[ꍇAAbstractBlancoValueObjectBatchProcessNXp blanco.valueobject.taskpbP[W BlancoValueObjectBatchProcessNX쐬邱Ƃɂłꍇ܂B
        final AbstractBlancoValueObjectBatchProcess batchProcess = new BlancoValueObjectBatchProcess();

        // ob`̈B
        final BlancoValueObjectBatchProcessInput input = new BlancoValueObjectBatchProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldMetadirProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-metadir=")) {
                input.setMetadir(arg.substring(9));
                isFieldMetadirProcessed = true;
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.startsWith("-nameAdjust=")) {
                input.setNameAdjust(Boolean.valueOf(arg.substring(12)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoValueObjectBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldMetadirProcessed == false) {
            System.out.println("BlancoValueObjectBatchProcess: JnsB̓p[^[input]̕K{tB[hl[metadir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public abstract int process(final BlancoValueObjectBatchProcessInput input) throws IOException, IllegalArgumentException;

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoValueObjectBatchProcessInput input) throws IllegalArgumentException {
        try {
            // ̓p[^`FbN܂B
            validateInput(input);

            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoValueObjectBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoValueObjectBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoValueObjectBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoValueObjectBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoValueObjectBatchProcess: Usage:");
        System.out.println("  java blanco.valueobject.task.BlancoValueObjectBatchProcess -verbose=l1 -metadir=l2 -targetdir=l3 -tmpdir=l4 -nameAdjust=l5");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -metadir");
        System.out.println("      [^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -targetdir");
        System.out.println("      [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[blanco]");
        System.out.println("    -tmpdir");
        System.out.println("      [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[tmp]");
        System.out.println("    -nameAdjust");
        System.out.println("      [tB[h⃁\bh𖼑Oό`{邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[true]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoValueObjectBatchProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getMetadir() == null) {
            throw new IllegalArgumentException("BlancoValueObjectBatchProcess: JnsB̓p[^[input]̕K{tB[hl[metadir]ɒlݒ肳Ă܂B");
        }
    }
}
