/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.encryption;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

import blanco.encryption.message.BlancoEncryptionMessage;

/**
 * 閧߂̃[eBeBNXB
 * 
 * @author IGA Tosiki
 */
public class BlancoEncryptionSecretKeyUtil {
    /**
     * bZ[WB
     */
    private static final BlancoEncryptionMessage fMsg = new BlancoEncryptionMessage();

    /**
     * gvDESpSHA-256_CWFXgp閧쐬܂B
     * 
     * SHA-25632oCĝŁADESedeŕKvƂȂ24oCg蒷̂ DESedeŗpۂɂ͂傤Ǔsǂ̂łB
     * 
     * @param argPassword
     *            pX[hB閧̎Ƃėp镶B
     * @return ꂽ閧B
     */
    public static SecretKey getSha256KeyForDesede(final String argPassword) {
        final String encryptAlgorithm = "DESede";
        final String keyDigestAlgorithm = "SHA-256";

        final byte[] digestedKey = getMessageDigest(keyDigestAlgorithm,
                argPassword);

        // ۂɗpL[쐬܂B
        // ŏ24oCĝݗp܂B
        final byte[] keySeed = copyBytes(digestedKey, 24);

        try {
            final SecretKeyFactory factory = SecretKeyFactory
                    .getInstance(encryptAlgorithm);

            // DESedep̃L[擾B
            return factory.generateSecret(new DESedeKeySpec(keySeed));
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde51(e.toString()));
        } catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde52(e.toString()));
        } catch (InvalidKeySpecException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde53(e.toString()));
        }
    }

    /**
     * w̃bZ[W_CWFXgASY𗘗păbZ[W_CWFXgl擾܂B
     * 
     * @param argDigestAlgorithm
     *            _CWFXgEASYB
     * @param argInputString
     *            ƂȂ镶B
     * @return bZ[W_CWFXglB
     */
    public static byte[] getMessageDigest(final String argDigestAlgorithm,
            final String argInputString) {
        try {
            final MessageDigest msgDigest = MessageDigest
                    .getInstance(argDigestAlgorithm);
            msgDigest.update(argInputString.getBytes("UTF-8"));
            return msgDigest.digest();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde61(
                    argDigestAlgorithm, e.toString()));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde62(e.toString()));
        }
    }

    /**
     * ^ꂽoCgzɁAw̒̃oCgz擾܂B
     * 
     * @param argInput
     * @param argLength
     * @return
     */
    private static byte[] copyBytes(final byte[] argInput, final int argLength) {
        final byte[] keySeed = new byte[argLength];
        for (int index = 0; index < keySeed.length; index++) {
            keySeed[index] = argInput[index];
        }
        return keySeed;
    }
}
