/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.encryption.task;

import java.io.IOException;

import blanco.encryption.task.valueobject.BlancoEncryptionDesedeBatchProcessInput;

/**
 * ob`NX [BlancoEncryptionDesedeBatchProcess]̒ېeNXB̃NX̓pbP[WANZXɌ肳Ă܂ (publicNXł͂܂)B
 *
 * ̃NXp [blanco.encryption.task]pbP[W[BlancoEncryptionDesedeBatchProcess]NX쐬Ďۂ̃ob`ĂB<br>
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.encryption.task.BlancoEncryptionDesedeBatchProcess -help
 * </code>
 */
abstract class AbstractBlancoEncryptionDesedeBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // ̉ӏŃRpCG[ꍇAAbstractBlancoEncryptionDesedeBatchProcessNXp blanco.encryption.taskpbP[W BlancoEncryptionDesedeBatchProcessNX쐬邱Ƃɂłꍇ܂B
        final AbstractBlancoEncryptionDesedeBatchProcess batchProcess = new BlancoEncryptionDesedeBatchProcess();

        // ob`̈B
        final BlancoEncryptionDesedeBatchProcessInput input = new BlancoEncryptionDesedeBatchProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldInputDirProcessed = false;
        boolean isFieldOutputDirProcessed = false;
        boolean isFieldPasswordProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-inputDir=")) {
                input.setInputDir(arg.substring(10));
                isFieldInputDirProcessed = true;
            } else if (arg.startsWith("-outputDir=")) {
                input.setOutputDir(arg.substring(11));
                isFieldOutputDirProcessed = true;
            } else if (arg.startsWith("-password=")) {
                input.setPassword(arg.substring(10));
                isFieldPasswordProcessed = true;
            } else if (arg.startsWith("-level=")) {
                try {
                    input.setLevel(Integer.parseInt(arg.substring(7)));
                } catch (NumberFormatException e) {
                    System.out.println("BlancoEncryptionDesedeBatchProcess: JnsB̓p[^[input]̃tB[h[level]𐔒l(int)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoEncryptionDesedeBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldInputDirProcessed == false) {
            System.out.println("BlancoEncryptionDesedeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[inputDir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldOutputDirProcessed == false) {
            System.out.println("BlancoEncryptionDesedeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[outputDir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldPasswordProcessed == false) {
            System.out.println("BlancoEncryptionDesedeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[password]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public abstract int process(final BlancoEncryptionDesedeBatchProcessInput input) throws IOException, IllegalArgumentException;

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoEncryptionDesedeBatchProcessInput input) throws IllegalArgumentException {
        try {
            // ̓p[^`FbN܂B
            validateInput(input);

            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoEncryptionDesedeBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoEncryptionDesedeBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoEncryptionDesedeBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoEncryptionDesedeBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoEncryptionDesedeBatchProcess: Usage:");
        System.out.println("  java blanco.encryption.task.BlancoEncryptionDesedeBatchProcess -verbose=l1 -inputDir=l2 -outputDir=l3 -password=l4 -level=l5");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -inputDir");
        System.out.println("      [̓fBNgw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -outputDir");
        System.out.println("      [o̓fBNgw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -password");
        System.out.println("      [pX[hw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -level");
        System.out.println("      [Í̃xB]");
        System.out.println("      ^[l(int)]");
        System.out.println("      ftHgl[1]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoEncryptionDesedeBatchProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getInputDir() == null) {
            throw new IllegalArgumentException("BlancoEncryptionDesedeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[inputDir]ɒlݒ肳Ă܂B");
        }
        if (input.getOutputDir() == null) {
            throw new IllegalArgumentException("BlancoEncryptionDesedeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[outputDir]ɒlݒ肳Ă܂B");
        }
        if (input.getPassword() == null) {
            throw new IllegalArgumentException("BlancoEncryptionDesedeBatchProcess: JnsB̓p[^[input]̕K{tB[hl[password]ɒlݒ肳Ă܂B");
        }
    }
}
