/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser.util;

import java.io.File;
import java.io.IOException;

import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.java.BlancoCgJavaSourceTransformer;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoFileUtil;
import blanco.html.parser.BlancoHtmlParser;
import blanco.html.parser.BlancoHtmlParserFactory;

public class BlancoHtmlCharacterEntitySetGenerator {
    public static void main(final String[] args)
            throws IllegalArgumentException, IOException, SAXException {
        final StringBuffer buf = new StringBuffer();

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setDeclHandler(new DeclHandler() {
            public void attributeDecl(String name, String name2, String type,
                    String mode, String value) throws SAXException {
            }

            public void elementDecl(String name, String model)
                    throws SAXException {
            }

            public void externalEntityDecl(String name, String publicId,
                    String systemId) throws SAXException {
            }

            public void internalEntityDecl(String name, String value)
                    throws SAXException {
                if (value.startsWith("&#")) {
                    value = value.substring(2);
                }
                if (value.endsWith(";")) {
                    value = value.substring(0, value.length() - 1);
                }
                final int intValue = Integer.valueOf(value);
                System.out.println("[" + name + "]:" + value + ":"
                        + (char) intValue);
                buf.append("{ \"" + name + "\", \"" + String.valueOf(intValue)
                        + "\" }, ");
            }

        });

        parser.parse(BlancoFileUtil.file2Bytes(new File(
                "./meta/program/spec/html4-lat1.txt")));
        parser.parse(BlancoFileUtil.file2Bytes(new File(
                "./meta/program/spec/html4-symbol.txt")));
        parser.parse(BlancoFileUtil.file2Bytes(new File(
                "./meta/program/spec/html4-special.txt")));

        // final String[][] a = { { "nbsp", "160" }, { "nbsp", "160" } };
        final BlancoCgObjectFactory cgFactory = BlancoCgObjectFactory
                .getInstance();
        final BlancoCgSourceFile cgSourceFile = cgFactory.createSourceFile(
                "blanco.html.parser.util", null);
        final BlancoCgClass cgClass = cgFactory.createClass(
                "BlancoHtmlCharacterEntitySetConstants",
                "HTML 4.0 GeBeBEZbg萔̃NXB");
        cgSourceFile.getClassList().add(cgClass);
        final BlancoCgField cgField = cgFactory.createField(
                "HTML_40_ENTITY_SET", "java.lang.String[][]", "GeBeBZbgB");
        cgClass.getFieldList().add(cgField);
        cgField.setAccess("public");
        cgField.setStatic(true);
        cgField.setFinal(true);
        cgField.setDefault("{ " + buf.toString() + " }");
        new BlancoCgJavaSourceTransformer().transform(cgSourceFile, new File(
                "blanco/main"));
    }
}
