package blanco.html.parser;

import java.io.File;

import junit.framework.TestCase;
import blanco.commons.util.BlancoFileUtil;

/**
 * <SCRIPT> ̃p[X܂B
 */
public class BlancoHtmlParserScriptTest extends TestCase {
    public void testParserScript001() throws Exception {
        new File("tmp").mkdirs();

        /**
         * script t html
         */
        final String htmlTestData = "<html>\n" + "<head>\n"
                + "<title>eXgf[^E^Cg</title>\n"
                + "<script type=\"text/javascript\">\n"
                + "Uso.Moon.Config = {\n" + "  entryNodes: {\n"
                + "    'div.section': {\n" + "      uri: 'h3 a',\n"
                + "      title: 'h3',\n" + "      container: 'h3'\n"
                + "    }\n" + "  }\n" + "};\n" + "</script>\n" + "</head>\n"
                + "<body>\n"
                + "<a href=http://sourceforge.jp/projects/blancofw/></a>\n"
                + "</body>\n" + "</html>";

        final byte[] inputData = htmlTestData.getBytes("Windows-31J");

        // HTML̃GR[fBO擾B
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        encodingParser.parse(inputData);

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        serializer.setWriter(BlancoHtmlParserTestUtil.getWriter(new File(
                "./tmp/testScript001.html"), encodingParser.getEncoding()));

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(serializer);
        parser.setLexicalHandler(serializer);
        parser.setDTDHandler(serializer);

        parser.parse(inputData);

        serializer.getWriter().close();

        final byte[] outputData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/testScript001.html"));

        assertEquals(new String(inputData, "Windows-31J"), new String(
                outputData, "Windows-31J"));
    }
}
