/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.xtagqxp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.xtagqxp.Xtag;
import org.omegat.util.OStrings;

public class XtagFilter
extends AbstractFilter {
    protected static final String EOL = "\r\n";
    private List<Xtag> listTags = new ArrayList<Xtag>();

    public String getFileFormatName() {
        return OStrings.getString("XTAGFILTER_FILTER_NAME");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.tag", "UTF-16LE", "UTF-16LE"), new Instance("*.xtg", "UTF-16LE", "UTF-16LE")};
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    public void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException, TranslationException {
        bufferedReader.mark(1);
        int n = bufferedReader.read();
        if (n != 65279) {
            bufferedReader.reset();
        } else {
            bufferedWriter.write(n);
        }
        this.processXtagFile(bufferedReader, bufferedWriter);
    }

    private void processXtagFile(BufferedReader bufferedReader, Writer writer) throws IOException, TranslationException {
        int n = 1;
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.startsWith("@$:")) {
                writer.write("@$:");
                string = string.substring(3);
                n = 2;
            } else if (string.startsWith("#boxname")) {
                n = 1;
            }
            String string2 = n == 2 ? this.privateProcessEntry(string) : string;
            writer.write(string2);
            string = bufferedReader.readLine();
            if (string == null) continue;
            writer.write(EOL);
        }
    }

    private String findTag(StringBuffer stringBuffer) {
        for (Xtag xtag : this.listTags) {
            if (!xtag.toShortcut().equals(stringBuffer.toString())) continue;
            return xtag.toOriginal();
        }
        Object object = "";
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            object = (String)object + this.convertSpecialCharacter(c);
        }
        return object;
    }

    private String convertSpecialCharacter(char c) {
        String string = "";
        string = c == '<' ? string + "<\\<>" : (c == '>' ? string + "<\\>>" : Character.toString(c));
        return string;
    }

    private String convertToTags(String string) {
        String string2 = "";
        int n = 1;
        int n2 = 0;
        this.listTags.clear();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<' && n != 2) {
                stringBuffer.setLength(0);
                n = 2;
                continue;
            }
            if (c == '>' && stringBuffer.lastIndexOf("\\") != stringBuffer.length() - 1) {
                Xtag xtag = new Xtag(stringBuffer.toString(), ++n2);
                string2 = string2 + xtag.toShortcut();
                this.listTags.add(xtag);
                stringBuffer.setLength(0);
                n = 1;
                continue;
            }
            if (n == 2) {
                stringBuffer.append(c);
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    private String convertToXtags(String string) {
        String string2 = "";
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<' && n != 2) {
                stringBuffer.setLength(0);
                stringBuffer.append(c);
                n = 2;
                continue;
            }
            if (c == '>' && n == 2) {
                stringBuffer.append(c);
                string2 = string2 + this.findTag(stringBuffer);
                n = 1;
                stringBuffer.setLength(0);
                continue;
            }
            if (n == 2) {
                stringBuffer.append(c);
                continue;
            }
            string2 = string2 + this.convertSpecialCharacter(c);
        }
        string2 = string2 + this.findTag(stringBuffer);
        return string2;
    }

    private String privateProcessEntry(String string) {
        string = this.convertToTags(string);
        string = this.processEntry(string);
        string = this.convertToXtags(string);
        return string;
    }
}

