/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegat.util.gui.ExtendedLabelView;

public final class Styles {
    public static final MutableAttributeSet PLAIN;
    public static final MutableAttributeSet BOLD;
    public static final MutableAttributeSet GREEN;
    public static final MutableAttributeSet TRANSLATED;
    public static final MutableAttributeSet UNTRANSLATED;
    public static final MutableAttributeSet MISSPELLED;
    public static final MutableAttributeSet DISABLED;
    public static final MutableAttributeSet TEXT_EXTRA;
    public static final MutableAttributeSet TEXT_BORDER;

    private Styles() {
    }

    public static MutableAttributeSet applyStyles(AttributeSet attributeSet, AttributeSet attributeSet2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        try {
            StyleConstants.setBackground(simpleAttributeSet, StyleConstants.getBackground(attributeSet));
        }
        catch (NullPointerException nullPointerException) {
            StyleConstants.setBackground(simpleAttributeSet, Color.white);
        }
        StyleConstants.setForeground(simpleAttributeSet, StyleConstants.getForeground(attributeSet2));
        StyleConstants.setBold(simpleAttributeSet, StyleConstants.isBold(attributeSet2));
        StyleConstants.setUnderline(simpleAttributeSet, StyleConstants.isUnderline(attributeSet2));
        ExtendedLabelView.setCustomUnderline(simpleAttributeSet, ExtendedLabelView.getCustomUnderline(attributeSet2));
        return simpleAttributeSet;
    }

    static {
        UIDefaults uIDefaults = UIManager.getDefaults();
        PLAIN = new SimpleAttributeSet();
        StyleConstants.setBackground(PLAIN, uIDefaults.getColor("TextPane.background"));
        StyleConstants.setForeground(PLAIN, uIDefaults.getColor("TextPane.foreground"));
        BOLD = new SimpleAttributeSet();
        StyleConstants.setBold(BOLD, true);
        GREEN = new SimpleAttributeSet();
        StyleConstants.setBold(GREEN, true);
        StyleConstants.setBackground(GREEN, new Color(192, 255, 192));
        TRANSLATED = new SimpleAttributeSet();
        StyleConstants.setBackground(TRANSLATED, new Color(255, 255, 153));
        UNTRANSLATED = new SimpleAttributeSet();
        StyleConstants.setBackground(UNTRANSLATED, new Color(204, 204, 255));
        DISABLED = new SimpleAttributeSet();
        StyleConstants.setForeground(DISABLED, uIDefaults.getColor("Label.disabledForeground"));
        TEXT_EXTRA = new SimpleAttributeSet();
        StyleConstants.setForeground(TEXT_EXTRA, Color.blue);
        TEXT_BORDER = new SimpleAttributeSet();
        StyleConstants.setForeground(TEXT_BORDER, Color.green);
        MISSPELLED = new SimpleAttributeSet();
        StyleConstants.setForeground(MISSPELLED, Color.black);
        ExtendedLabelView.setCustomUnderline(MISSPELLED, 2);
    }
}

