/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;

public class ExtendedLabelView
extends LabelView {
    public static final int NO_CUSTOM_UNDERLINE = -1;
    public static final int RED_UNDERLINE = 1;
    public static final int RED_JAGGED_UNDERLINE = 2;
    public static final String CustomUnderline = "customUnderline";
    private Element element;

    public ExtendedLabelView(Element element) {
        super(element);
        this.element = element;
    }

    public void paint(Graphics graphics, Shape shape) {
        super.paint(graphics, shape);
        int n = ExtendedLabelView.getCustomUnderline(this.element.getAttributes());
        switch (n) {
            case 1: {
                this.paintLine(graphics, shape, Color.red);
                break;
            }
            case 2: {
                this.paintJaggedLine(graphics, shape, Color.red);
            }
        }
    }

    public void paintJaggedLine(Graphics graphics, Shape shape, Color color) {
        int n = (int)(shape.getBounds().getY() + shape.getBounds().getHeight());
        int n2 = (int)shape.getBounds().getX();
        int n3 = (int)(shape.getBounds().getX() + shape.getBounds().getWidth());
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        int n4 = 3;
        int n5 = 2;
        for (int i = n2; i <= n3; i += n4 * 2) {
            graphics.drawArc(i + 0, n - n5, n4, n5, 0, 180);
            graphics.drawArc(i + n4, n - n5, n4, n5, 180, 181);
        }
        graphics.setColor(color2);
    }

    public void paintLine(Graphics graphics, Shape shape, Color color) {
        int n = (int)(shape.getBounds().getY() + shape.getBounds().getHeight());
        int n2 = (int)shape.getBounds().getX();
        int n3 = (int)(shape.getBounds().getX() + shape.getBounds().getWidth());
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawLine(n2, n - 2, n3, n - 2);
        graphics.setColor(color2);
    }

    public static int getCustomUnderline(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(CustomUnderline);
        if (object != null) {
            try {
                return Integer.parseInt(object.toString());
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    public static void setCustomUnderline(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(CustomUnderline, new Integer(n));
    }
}

