/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.openxml;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.openxml.EditOpenXMLOptionsDialog;
import org.omegat.filters3.xml.openxml.OpenXMLDialect;
import org.omegat.filters3.xml.openxml.OpenXMLOptions;
import org.omegat.filters3.xml.openxml.OpenXMLXMLFilter;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenXMLFilter
extends AbstractFilter {
    private String DOCUMENTS = "(document\\.xml)";
    private Pattern TRANSLATABLE;
    private static final Pattern DIGITS = Pattern.compile("(\\d+)\\.xml");
    private boolean optionsAlreadyRead = false;
    OpenXMLXMLFilter xmlfilter = null;

    private void defineDOCUMENTSOptions() {
        if (!this.optionsAlreadyRead) {
            OpenXMLOptions openXMLOptions = (OpenXMLOptions)this.getOptions();
            if (openXMLOptions == null) {
                openXMLOptions = new OpenXMLOptions();
            }
            if (openXMLOptions.getTranslateComments()) {
                this.DOCUMENTS = this.DOCUMENTS + "|(comments\\.xml)";
            }
            if (openXMLOptions.getTranslateFootnotes()) {
                this.DOCUMENTS = this.DOCUMENTS + "|(footnotes\\.xml)";
            }
            if (openXMLOptions.getTranslateEndnotes()) {
                this.DOCUMENTS = this.DOCUMENTS + "|(endnotes\\.xml)";
            }
            if (openXMLOptions.getTranslateHeaders()) {
                this.DOCUMENTS = this.DOCUMENTS + "|(header\\d+\\.xml)";
            }
            if (openXMLOptions.getTranslateFooters()) {
                this.DOCUMENTS = this.DOCUMENTS + "|(footer\\d+\\.xml)";
            }
            this.DOCUMENTS = this.DOCUMENTS + "|(sharedStrings\\.xml)";
            if (openXMLOptions.getTranslateExcelComments()) {
                this.DOCUMENTS = this.DOCUMENTS + "|(comments\\d+\\.xml)";
            }
            this.DOCUMENTS = this.DOCUMENTS + "|(slide\\d+\\.xml)";
            if (openXMLOptions.getTranslateSlideMasters()) {
                this.DOCUMENTS = this.DOCUMENTS + "|(slideMaster\\d+\\.xml)";
            }
            if (openXMLOptions.getTranslateSlideComments()) {
                this.DOCUMENTS = this.DOCUMENTS + "|(notesSlide\\d+\\.xml)";
            }
            this.TRANSLATABLE = Pattern.compile(this.DOCUMENTS);
            this.optionsAlreadyRead = true;
        }
    }

    @Override
    public boolean isFileSupported(File file, String string) {
        try {
            this.defineDOCUMENTSOptions();
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                Matcher matcher = this.TRANSLATABLE.matcher(string2 = this.removePath(string2));
                if (!matcher.matches()) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private OpenXMLXMLFilter getXMLFilter() {
        if (this.xmlfilter == null) {
            this.xmlfilter = new OpenXMLXMLFilter();
            this.xmlfilter.setParseCallback(this.entryProcessingCallback);
        }
        OpenXMLDialect openXMLDialect = (OpenXMLDialect)this.xmlfilter.getDialect();
        openXMLDialect.defineDialect((OpenXMLOptions)this.getOptions());
        return this.xmlfilter;
    }

    private File tmp() throws IOException {
        return File.createTempFile("o-xml-temp", ".xml");
    }

    private String removePath(String string) {
        if (string.lastIndexOf(47) >= 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        return string;
    }

    private String removeXML(String string) {
        if (string.endsWith(".xml")) {
            string = string.substring(0, string.lastIndexOf(".xml"));
        }
        return string;
    }

    @Override
    public List<File> processFile(File file, String string, File file2, String string2) throws IOException, TranslationException {
        this.defineDOCUMENTSOptions();
        ZipFile zipFile = new ZipFile(file);
        ZipOutputStream zipOutputStream = null;
        if (file2 != null) {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<? extends ZipEntry> arrayList = Collections.list(enumeration);
        Collections.sort(arrayList, new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry zipEntry, ZipEntry zipEntry2) {
                int n;
                String string = zipEntry.getName();
                String string2 = zipEntry2.getName();
                String[] stringArray = string.split("\\d+\\.");
                String[] stringArray2 = string2.split("\\d+\\.");
                if (stringArray.length > 1 && stringArray2.length > 1 && stringArray[0].equals(stringArray2[0])) {
                    int n2 = 0;
                    int n3 = 0;
                    Matcher matcher = DIGITS.matcher(string);
                    if (matcher.find()) {
                        n2 = Integer.parseInt(matcher.group(1));
                    }
                    if ((matcher = DIGITS.matcher(string2)).find()) {
                        n3 = Integer.parseInt(matcher.group(1));
                    }
                    if (n2 > n3) {
                        return 1;
                    }
                    if (n2 < n3) {
                        return -1;
                    }
                    return 0;
                }
                String string3 = OpenXMLFilter.this.removePath(stringArray[0]);
                string3 = OpenXMLFilter.this.removeXML(string3);
                String string4 = OpenXMLFilter.this.removePath(stringArray2[0]);
                string4 = OpenXMLFilter.this.removeXML(string4);
                if (string3.indexOf("sharedStrings") >= 0 || string4.indexOf("sharedStrings") >= 0) {
                    if (string4.indexOf("sharedStrings") >= 0) {
                        return 1;
                    }
                    return -1;
                }
                int n4 = OpenXMLFilter.this.DOCUMENTS.indexOf(string3);
                if (n4 > (n = OpenXMLFilter.this.DOCUMENTS.indexOf(string4))) {
                    return 1;
                }
                if (n4 < n) {
                    return -1;
                }
                return 0;
            }
        });
        Enumeration<? extends ZipEntry> enumeration2 = Collections.enumeration(arrayList);
        while (enumeration2.hasMoreElements()) {
            Object object;
            ZipEntry zipEntry = enumeration2.nextElement();
            String string3 = zipEntry.getName();
            string3 = this.removePath(string3);
            Matcher matcher = this.TRANSLATABLE.matcher(string3);
            boolean bl = true;
            if (matcher.matches()) {
                object = this.tmp();
                LFileCopy.copy(zipFile.getInputStream(zipEntry), (File)object);
                File file3 = null;
                if (zipOutputStream != null) {
                    file3 = this.tmp();
                }
                try {
                    this.getXMLFilter().processFile((File)object, null, file3, null);
                }
                catch (Exception exception) {
                    throw new TranslationException(exception.getLocalizedMessage() + "\n" + OStrings.getString("OpenXML_ERROR_IN_FILE") + file);
                }
                if (zipOutputStream != null) {
                    ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                    zipOutputStream.putNextEntry(zipEntry2);
                    LFileCopy.copy(file3, (OutputStream)zipOutputStream);
                    zipOutputStream.closeEntry();
                    bl = false;
                }
                if (!((File)object).delete()) {
                    ((File)object).deleteOnExit();
                }
                if (file3 == null || file3.delete()) continue;
                file3.deleteOnExit();
                continue;
            }
            if (zipOutputStream == null) continue;
            object = new ZipEntry(zipEntry.getName());
            zipOutputStream.putNextEntry((ZipEntry)object);
            LFileCopy.copy(zipFile.getInputStream(zipEntry), (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
        return null;
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("OpenXML_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.doc?"), new Instance("*.xls?"), new Instance("*.ppt?")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    protected void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException, TranslationException {
        throw new IOException("Not Implemented!");
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Serializable changeOptions(Dialog dialog, Serializable serializable) {
        try {
            OpenXMLOptions openXMLOptions = (OpenXMLOptions)serializable;
            EditOpenXMLOptionsDialog editOpenXMLOptionsDialog = new EditOpenXMLOptionsDialog(dialog, openXMLOptions);
            editOpenXMLOptionsDialog.setVisible(true);
            if (1 == editOpenXMLOptionsDialog.getReturnStatus()) {
                return editOpenXMLOptionsDialog.getOptions();
            }
            return serializable;
        }
        catch (Exception exception) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(exception);
            return serializable;
        }
    }
}

