/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.ini;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.OStrings;

public class INIFilter
extends AbstractFilter {
    public String getFileFormatName() {
        return OStrings.getString("INIFILTER_FILTER_NAME");
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.ini"), new Instance("*.lng")};
    }

    private String leftTrim(String string) {
        int n;
        for (n = 0; n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t'); ++n) {
        }
        return string.substring(n, string.length());
    }

    public void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException {
        String string;
        LinebreakPreservingReader linebreakPreservingReader = new LinebreakPreservingReader(bufferedReader);
        while ((string = linebreakPreservingReader.readLine()) != null) {
            String string2 = string.trim();
            if (string2.length() == 0 || string2.charAt(0) == '#' || string2.charAt(0) == ';') {
                bufferedWriter.write(string + linebreakPreservingReader.getLinebreak());
                continue;
            }
            int n = string.indexOf(61);
            if (n == -1) {
                n = string.length() - 1;
            }
            while (n + 1 < string.length() && string.charAt(n + 1) == ' ') {
                ++n;
            }
            bufferedWriter.write(string.substring(0, n + 1));
            String string3 = string.substring(n + 1);
            string3 = this.leftTrim(string3);
            String string4 = this.processEntry(string3);
            bufferedWriter.write(string4);
            bufferedWriter.write(linebreakPreservingReader.getLinebreak());
        }
    }
}

