/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import net.roydesign.mac.MRJAdapter;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowMenuHandler;
import org.omegat.gui.main.MainWindowMenuShortcuts;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class MainWindowMenu
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(MainWindowMenu.class.getName());
    protected final MainWindow mainWindow;
    protected final MainWindowMenuHandler mainWindowMenuHandler;
    JMenuItem cycleSwitchCaseMenuItem;
    JMenuItem editFindInProjectMenuItem;
    JMenuItem editInsertSourceMenuItem;
    JMenuItem editInsertTranslationMenuItem;
    JMenu editMenu;
    JMenuItem editOverwriteSourceMenuItem;
    JMenuItem editOverwriteTranslationMenuItem;
    JMenuItem editRedoMenuItem;
    JMenuItem editSelectFuzzy1MenuItem;
    JMenuItem editSelectFuzzy2MenuItem;
    JMenuItem editSelectFuzzy3MenuItem;
    JMenuItem editSelectFuzzy4MenuItem;
    JMenuItem editSelectFuzzy5MenuItem;
    JMenuItem editUndoMenuItem;
    JMenuItem editExportSelectionMenuItem;
    public JMenuItem gotoHistoryBackMenuItem;
    public JMenuItem gotoHistoryForwardMenuItem;
    JMenu gotoMenu;
    JMenuItem gotoNextSegmentMenuItem;
    JMenuItem gotoNextUntranslatedMenuItem;
    JMenuItem gotoPreviousSegmentMenuItem;
    JMenuItem gotoSegmentMenuItem;
    JMenuItem helpAboutMenuItem;
    JMenuItem helpContentsMenuItem;
    JMenu helpMenu;
    JMenuItem lowerCaseMenuItem;
    JMenuBar mainMenu;
    JCheckBoxMenuItem optionsAlwaysConfirmQuitCheckBoxMenuItem;
    JMenuItem optionsFontSelectionMenuItem;
    JMenu optionsMenu;
    JMenuItem optionsRestoreGUIMenuItem;
    JMenuItem optionsSentsegMenuItem;
    JMenuItem optionsSetupFileFiltersMenuItem;
    JMenuItem optionsSpellCheckMenuItem;
    JCheckBoxMenuItem optionsTabAdvanceCheckBoxMenuItem;
    JMenuItem optionsWorkflowMenuItem;
    JMenuItem projectCloseMenuItem;
    JMenuItem projectCompileMenuItem;
    JMenuItem projectEditMenuItem;
    JMenuItem projectExitMenuItem;
    JMenuItem projectImportMenuItem;
    JMenu projectMenu;
    JMenuItem projectNewMenuItem;
    JMenuItem projectOpenMenuItem;
    JMenuItem projectReloadMenuItem;
    JMenuItem projectSaveMenuItem;
    JMenuItem projectWikiImportMenuItem;
    JMenu switchCaseSubMenu;
    JMenuItem titleCaseMenuItem;
    JMenu toolsMenu;
    JMenuItem toolsValidateTagsMenuItem;
    JMenuItem upperCaseMenuItem;
    JCheckBoxMenuItem viewDisplaySegmentSourceCheckBoxMenuItem;
    JMenuItem viewFileListMenuItem;
    JCheckBoxMenuItem viewMarkTranslatedSegmentsCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkUntranslatedSegmentsCheckBoxMenuItem;
    JMenu viewMenu;

    public MainWindowMenu(MainWindow mainWindow, MainWindowMenuHandler mainWindowMenuHandler) {
        this.mainWindow = mainWindow;
        this.mainWindowMenuHandler = mainWindowMenuHandler;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getActionCommand();
        Log.logInfoRB("LOG_MENU_CLICK", string);
        String string2 = string + "ActionPerformed";
        Method method = null;
        try {
            method = this.mainWindowMenuHandler.getClass().getMethod(string2, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
        try {
            method.invoke((Object)this.mainWindowMenuHandler, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.log(Level.SEVERE, "Error execute method", invocationTargetException);
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
    }

    JMenuBar initComponents() {
        this.mainMenu = new JMenuBar();
        this.projectMenu = this.createMenu("TF_MENU_FILE");
        this.mainMenu.add(this.projectMenu);
        this.editMenu = this.createMenu("TF_MENU_EDIT");
        this.mainMenu.add(this.editMenu);
        this.gotoMenu = this.createMenu("MW_GOTOMENU");
        this.mainMenu.add(this.gotoMenu);
        this.viewMenu = this.createMenu("MW_VIEW_MENU");
        this.mainMenu.add(this.viewMenu);
        this.toolsMenu = this.createMenu("TF_MENU_TOOLS");
        this.mainMenu.add(this.toolsMenu);
        this.optionsMenu = this.createMenu("MW_OPTIONSMENU");
        this.mainMenu.add(this.optionsMenu);
        this.helpMenu = this.createMenu("TF_MENU_HELP");
        this.mainMenu.add(this.helpMenu);
        this.projectNewMenuItem = this.createMenuItem("TF_MENU_FILE_CREATE");
        this.projectMenu.add(this.projectNewMenuItem);
        this.projectOpenMenuItem = this.createMenuItem("TF_MENU_FILE_OPEN");
        this.projectMenu.add(this.projectOpenMenuItem);
        this.projectImportMenuItem = this.createMenuItem("TF_MENU_FILE_IMPORT");
        this.projectMenu.add(this.projectImportMenuItem);
        this.projectWikiImportMenuItem = this.createMenuItem("TF_MENU_WIKI_IMPORT");
        this.projectMenu.add(this.projectWikiImportMenuItem);
        this.projectReloadMenuItem = this.createMenuItem("TF_MENU_PROJECT_RELOAD");
        this.projectMenu.add(this.projectReloadMenuItem);
        this.projectCloseMenuItem = this.createMenuItem("TF_MENU_FILE_CLOSE");
        this.projectMenu.add(this.projectCloseMenuItem);
        this.projectMenu.add(new JSeparator());
        this.projectSaveMenuItem = this.createMenuItem("TF_MENU_FILE_SAVE");
        this.projectMenu.add(this.projectSaveMenuItem);
        this.projectMenu.add(new JSeparator());
        this.projectCompileMenuItem = this.createMenuItem("TF_MENU_FILE_COMPILE");
        this.projectMenu.add(this.projectCompileMenuItem);
        this.projectMenu.add(new JSeparator());
        this.projectEditMenuItem = this.createMenuItem("MW_PROJECTMENU_EDIT");
        this.projectMenu.add(this.projectEditMenuItem);
        this.viewFileListMenuItem = this.createMenuItem("TF_MENU_FILE_PROJWIN");
        this.projectMenu.add(this.viewFileListMenuItem);
        this.projectExitMenuItem = this.createMenuItem("TF_MENU_FILE_QUIT");
        if (!StaticUtils.onMacOSX()) {
            this.projectMenu.add(new JSeparator());
            this.projectMenu.add(this.projectExitMenuItem);
        }
        this.editUndoMenuItem = this.createMenuItem("TF_MENU_EDIT_UNDO");
        this.editMenu.add(this.editUndoMenuItem);
        this.editRedoMenuItem = this.createMenuItem("TF_MENU_EDIT_REDO");
        this.editMenu.add(this.editRedoMenuItem);
        this.editMenu.add(new JSeparator());
        this.editOverwriteTranslationMenuItem = this.createMenuItem("TF_MENU_EDIT_RECYCLE");
        this.editMenu.add(this.editOverwriteTranslationMenuItem);
        this.editInsertTranslationMenuItem = this.createMenuItem("TF_MENU_EDIT_INSERT");
        this.editMenu.add(this.editInsertTranslationMenuItem);
        this.editMenu.add(new JSeparator());
        this.editOverwriteSourceMenuItem = this.createMenuItem("TF_MENU_EDIT_SOURCE_OVERWRITE");
        this.editMenu.add(this.editOverwriteSourceMenuItem);
        this.editInsertSourceMenuItem = this.createMenuItem("TF_MENU_EDIT_SOURCE_INSERT");
        this.editMenu.add(this.editInsertSourceMenuItem);
        this.editMenu.add(new JSeparator());
        this.editExportSelectionMenuItem = this.createMenuItem("TF_MENU_EDIT_EXPORT_SELECTION");
        this.editMenu.add(this.editExportSelectionMenuItem);
        this.editMenu.add(new JSeparator());
        this.editFindInProjectMenuItem = this.createMenuItem("TF_MENU_EDIT_FIND");
        this.editMenu.add(this.editFindInProjectMenuItem);
        this.editMenu.add(new JSeparator());
        this.switchCaseSubMenu = this.createMenu("TF_EDIT_MENU_SWITCH_CASE");
        this.editMenu.add(this.switchCaseSubMenu);
        this.editMenu.add(new JSeparator());
        this.editSelectFuzzy1MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_1");
        this.editMenu.add(this.editSelectFuzzy1MenuItem);
        this.editSelectFuzzy2MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_2");
        this.editMenu.add(this.editSelectFuzzy2MenuItem);
        this.editSelectFuzzy3MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_3");
        this.editMenu.add(this.editSelectFuzzy3MenuItem);
        this.editSelectFuzzy4MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_4");
        this.editMenu.add(this.editSelectFuzzy4MenuItem);
        this.editSelectFuzzy5MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_5");
        this.editMenu.add(this.editSelectFuzzy5MenuItem);
        this.lowerCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_LOWER");
        this.switchCaseSubMenu.add(this.lowerCaseMenuItem);
        this.upperCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_UPPER");
        this.switchCaseSubMenu.add(this.upperCaseMenuItem);
        this.titleCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_TITLE");
        this.switchCaseSubMenu.add(this.titleCaseMenuItem);
        this.switchCaseSubMenu.add(new JSeparator());
        this.cycleSwitchCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_CYCLE");
        this.switchCaseSubMenu.add(this.cycleSwitchCaseMenuItem);
        this.gotoNextUntranslatedMenuItem = this.createMenuItem("TF_MENU_EDIT_UNTRANS");
        this.gotoMenu.add(this.gotoNextUntranslatedMenuItem);
        this.gotoNextSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_NEXT");
        this.gotoMenu.add(this.gotoNextSegmentMenuItem);
        this.gotoPreviousSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_PREV");
        this.gotoMenu.add(this.gotoPreviousSegmentMenuItem);
        this.gotoSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_GOTO");
        this.gotoMenu.add(this.gotoSegmentMenuItem);
        this.gotoMenu.add(new JSeparator());
        this.gotoHistoryForwardMenuItem = this.createMenuItem("TF_MENU_GOTO_FORWARD_IN_HISTORY");
        this.gotoMenu.add(this.gotoHistoryForwardMenuItem);
        this.gotoHistoryBackMenuItem = this.createMenuItem("TF_MENU_GOTO_BACK_IN_HISTORY");
        this.gotoMenu.add(this.gotoHistoryBackMenuItem);
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_MARK_TRANSLATED");
        this.viewMenu.add(this.viewMarkTranslatedSegmentsCheckBoxMenuItem);
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_MARK_UNTRANSLATED");
        this.viewMenu.add(this.viewMarkUntranslatedSegmentsCheckBoxMenuItem);
        this.viewDisplaySegmentSourceCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_DISPLAY_SEGMENT_SOURCES");
        this.viewMenu.add(this.viewDisplaySegmentSourceCheckBoxMenuItem);
        this.toolsValidateTagsMenuItem = this.createMenuItem("TF_MENU_TOOLS_VALIDATE");
        this.toolsMenu.add(this.toolsValidateTagsMenuItem);
        this.optionsTabAdvanceCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_ADVANCE");
        this.optionsMenu.add(this.optionsTabAdvanceCheckBoxMenuItem);
        this.optionsAlwaysConfirmQuitCheckBoxMenuItem = this.createCheckboxMenuItem("MW_OPTIONSMENU_ALWAYS_CONFIRM_QUIT");
        this.optionsMenu.add(this.optionsAlwaysConfirmQuitCheckBoxMenuItem);
        this.optionsMenu.add(new JSeparator());
        this.optionsFontSelectionMenuItem = this.createMenuItem("TF_MENU_DISPLAY_FONT");
        this.optionsMenu.add(this.optionsFontSelectionMenuItem);
        this.optionsSetupFileFiltersMenuItem = this.createMenuItem("TF_MENU_DISPLAY_FILTERS");
        this.optionsMenu.add(this.optionsSetupFileFiltersMenuItem);
        this.optionsSentsegMenuItem = this.createMenuItem("MW_OPTIONSMENU_SENTSEG");
        this.optionsMenu.add(this.optionsSentsegMenuItem);
        this.optionsSpellCheckMenuItem = this.createMenuItem("MW_OPTIONSMENU_SPELLCHECK");
        this.optionsMenu.add(this.optionsSpellCheckMenuItem);
        this.optionsWorkflowMenuItem = this.createMenuItem("MW_OPTIONSMENU_WORKFLOW");
        this.optionsMenu.add(this.optionsWorkflowMenuItem);
        this.optionsRestoreGUIMenuItem = this.createMenuItem("MW_OPTIONSMENU_RESTORE_GUI");
        this.optionsMenu.add(this.optionsRestoreGUIMenuItem);
        this.helpContentsMenuItem = this.createMenuItem("TF_MENU_HELP_CONTENTS");
        this.helpMenu.add(this.helpContentsMenuItem);
        this.helpAboutMenuItem = this.createMenuItem("TF_MENU_HELP_ABOUT");
        this.helpMenu.add(this.helpAboutMenuItem);
        this.setActionCommands();
        MainWindowMenuShortcuts.setShortcuts(this.mainMenu);
        this.initMacSpecific();
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            public void onApplicationStartup() {
                MainWindowMenu.this.updateCheckboxesOnStart();
                MainWindowMenu.this.onProjectStatusChanged(false);
            }

            public void onApplicationShutdown() {
            }
        });
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                if (Core.getProject().isProjectLoaded()) {
                    MainWindowMenu.this.onProjectStatusChanged(true);
                } else {
                    MainWindowMenu.this.onProjectStatusChanged(false);
                }
            }
        });
        return this.mainMenu;
    }

    private void updateCheckboxesOnStart() {
        this.optionsTabAdvanceCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isUseTabForAdvance());
        this.optionsAlwaysConfirmQuitCheckBoxMenuItem.setSelected(Preferences.isPreference("always_confirm_quit"));
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkTranslated());
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkUntranslated());
        this.viewDisplaySegmentSourceCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isDisplaySegmentSources());
    }

    private void initMacSpecific() {
        try {
            MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindowMenu.this.mainWindowMenuHandler.projectExitMenuItemActionPerformed();
                }
            });
            MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindowMenu.this.mainWindowMenuHandler.helpAboutMenuItemActionPerformed();
                }
            });
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Log.log(noClassDefFoundError);
        }
    }

    private JMenu createMenu(String string) {
        JMenu jMenu = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)jMenu, (String)OStrings.getString(string));
        return jMenu;
    }

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)OStrings.getString(string));
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private JCheckBoxMenuItem createCheckboxMenuItem(String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)jCheckBoxMenuItem, (String)OStrings.getString(string));
        jCheckBoxMenuItem.addActionListener(this);
        return jCheckBoxMenuItem;
    }

    protected void setActionCommands() {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!JMenuItem.class.isAssignableFrom(field.getType()) || field.getType() == JMenu.class) continue;
                JMenuItem jMenuItem = (JMenuItem)field.get(this);
                jMenuItem.setActionCommand(field.getName());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExceptionInInitializerError(illegalAccessException);
        }
    }

    private void onProjectStatusChanged(boolean bl) {
        JMenuItem[] jMenuItemArray = new JMenuItem[]{this.projectNewMenuItem, this.projectOpenMenuItem};
        JMenuItem[] jMenuItemArray2 = new JMenuItem[]{this.projectImportMenuItem, this.projectWikiImportMenuItem, this.projectReloadMenuItem, this.projectCloseMenuItem, this.projectSaveMenuItem, this.projectEditMenuItem, this.projectCompileMenuItem, this.editMenu, this.editFindInProjectMenuItem, this.editInsertSourceMenuItem, this.editInsertTranslationMenuItem, this.editOverwriteSourceMenuItem, this.editOverwriteTranslationMenuItem, this.editRedoMenuItem, this.editSelectFuzzy1MenuItem, this.editSelectFuzzy2MenuItem, this.editSelectFuzzy3MenuItem, this.editSelectFuzzy4MenuItem, this.editSelectFuzzy5MenuItem, this.editUndoMenuItem, this.switchCaseSubMenu, this.gotoMenu, this.gotoNextSegmentMenuItem, this.gotoNextUntranslatedMenuItem, this.gotoPreviousSegmentMenuItem, this.gotoSegmentMenuItem, this.viewFileListMenuItem, this.toolsValidateTagsMenuItem};
        for (JMenuItem jMenuItem : jMenuItemArray) {
            jMenuItem.setEnabled(!bl);
        }
        for (JMenuItem jMenuItem : jMenuItemArray2) {
            jMenuItem.setEnabled(bl);
        }
    }
}

