/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.xliff2tmx.task;

import java.io.IOException;

import blanco.xliff2tmx.task.valueobject.BlancoXliff2TmxProcessInput;

/**
 * ob`NX [BlancoXliff2TmxBatchProcess]B
 *
 * <P>ob`̌ĂяoB</P>
 * <code>
 * java -classpath (NXpX) blanco.xliff2tmx.task.BlancoXliff2TmxBatchProcess -help
 * </code>
 */
public class BlancoXliff2TmxBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoXliff2TmxBatchProcess batchProcess = new BlancoXliff2TmxBatchProcess();

        // ob`̈B
        final BlancoXliff2TmxProcessInput input = new BlancoXliff2TmxProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldSourcedirProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourcedir=")) {
                input.setSourcedir(arg.substring(11));
                isFieldSourcedirProcessed = true;
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-targetfile=")) {
                input.setTargetfile(arg.substring(12));
            } else if (arg.startsWith("-checkalttranspleiades=")) {
                input.setCheckalttranspleiades(Boolean.valueOf(arg.substring(23)).booleanValue());
            } else if (arg.startsWith("-checktmomit=")) {
                input.setChecktmomit(Boolean.valueOf(arg.substring(13)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoXliff2TmxBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldSourcedirProcessed == false) {
            System.out.println("BlancoXliff2TmxBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoXliff2TmxProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoXliff2TmxProcessC^tF[X blanco.xliff2tmx.taskpbP[W BlancoXliff2TmxProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoXliff2TmxProcess process = new BlancoXliff2TmxProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoXliff2TmxProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoXliff2TmxBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoXliff2TmxBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoXliff2TmxBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoXliff2TmxBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoXliff2TmxBatchProcess: Usage:");
        System.out.println("  java blanco.xliff2tmx.task.BlancoXliff2TmxBatchProcess -verbose=l1 -sourcedir=l2 -targetdir=l3 -targetfile=l4 -checkalttranspleiades=l5 -checktmomit=l6");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourcedir");
        System.out.println("      [͂ƂȂ OASIS XLIFF t@Ci[ĂfBNgB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -targetdir");
        System.out.println("      [o͂ƂȂ TMX t@Ci[fBNgBtargetfile ƔrIɗpB]");
        System.out.println("      ^[]");
        System.out.println("    -targetfile");
        System.out.println("      [o͂ƂȂ TMX t@C̃t@CBtargetdir ƔrIɗpB]");
        System.out.println("      ^[]");
        System.out.println("    -checkalttranspleiades");
        System.out.println("      [alt-trans Pleiades ƈvꍇɂ̂TMX쐬邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -checktmomit");
        System.out.println("      [context ɂ TmΏۊOtO`FbN邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[true]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoXliff2TmxProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getSourcedir() == null) {
            throw new IllegalArgumentException("BlancoXliff2TmxBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
        }
    }
}
