/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 */
public class FinalizeDotNet extends BlancoDbAbstractMethod {
    public FinalizeDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("Finalize",
                "Finalize\bh");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.setAccess("protected");

        cgMethod.getLangDoc().getDescriptionList().add(
                "N[YỸoOm邱ƂړIƂ܂B");

        final List<String> listLine = cgMethod.getLineList();

        listLine.add("if (fStatement != null) {");
        listLine.add("const String message = \"" + fCgClass.getName()
                + " : Close()\bhɂ郊\[X̊JsĂ܂B\";");
        listLine.add("System.Console.WriteLine(message);");

        if (fDbSetting.getLogging()) {
            listLine.add("");
            listLine.add("fLog.error(\"" + cgMethod.getName()
                    + ": \" + message);");
        }

        listLine.add("}");
    }
}