/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.odp;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 */
public class GetQueryMethodOdpDotNet extends BlancoDbAbstractMethod {
    public GetQueryMethodOdpDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        fCgSourceFile.getImportList().add("System.String");
        fCgSourceFile.getImportList().add("System.Text.StringBuilder");

        final BlancoCgMethod cgMethod = fCgFactory.createMethod("GetQuery",
                "NG̎擾\bh");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.setReturn(fCgFactory.createReturn("string", "ۂɎsSQL"));

        cgMethod.getLangDoc().getDescriptionList().add("ۂɎsSQL߂܂B");

        final List<String> listLine = cgMethod.getLineList();

        final String escapedQuery = BlancoJavaSourceUtil
                .escapeStringAsJavaSource(fSqlInfo.getQuery());

        // NG #p[^?ւ̕ϊ
        final String actualSql = getNaturalSqlStringForDotNet(escapedQuery);

        // SQLs̕ŕf܂B
        final String[] sqlLines = splitString(actualSql, "\\n");

        listLine.add("StringBuilder builder = new StringBuilder();");
        for (int index = 0; index < sqlLines.length; index++) {
            if (index == 0) {
                listLine.add("builder.Append(\"" + sqlLines[index] + "\");");
            } else {
                listLine.add("builder.Append(\"" + sqlLines[index] + "\");");
            }
        }

        listLine.add("return builder.ToString();");
    }

    /**
     * ^ꂽw̕ĕ܂B
     * 
     * APIł́A͕񂩂Ď镶͂܂B<br>
     * ʊ֐̌API
     * 
     * @param originalString
     * @param delimiterString
     * @return
     */
    public static String[] splitString(final String originalString,
            final String delimiterString) {
        final List<String> result = new ArrayList<String>();
        String nextString = originalString;

        for (;;) {
            if (nextString.length() == 0) {
                break;
            }
            final int find = nextString.indexOf(delimiterString);
            if (find >= 0
                    && find + delimiterString.length() <= nextString.length()) {
                final String item = nextString.substring(0, find
                        + delimiterString.length());
                result.add(item);
                nextString = nextString.substring(find
                        + delimiterString.length());
            } else {
                result.add(nextString);
                break;
            }
        }

        final String[] resultStringArray = new String[result.size()];
        result.toArray(resultStringArray);
        return resultStringArray;
    }

    /**
     * IteratorɎۂɒ荞܂i`SQL
     * 
     * @return
     */
    public static String getNaturalSqlStringForDotNet(
            final String originalSqlQueryString) {
        final String SZ_PARAMETER_FOR_SQL_INPUT_PARAMETER = "#[a-zA-Z0-9.\\-_\\P{InBasicLatin}]*\\b|#.*$";

        final Matcher matcher = Pattern.compile(
                SZ_PARAMETER_FOR_SQL_INPUT_PARAMETER).matcher(
                originalSqlQueryString);
        String resultSql = originalSqlQueryString;
        for (int index = 1; matcher.find(); index++) {
            String name = matcher.group();
            // 擪́܂B
            name = name.substring(1, name.length());
            // TODO  inParamvtBbNXt^Ă̂JavałƂ͈قȂ鋓łB
            resultSql = resultSql.replaceAll("#" + name, ":" + name);
        }
        return resultSql;
    }
}