/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.dbmetadata.task;

import java.io.IOException;

import blanco.dbmetadata.task.valueobject.BlancoDbMetaDataMeta2CsvProcessInput;

/**
 * ob`NX [BlancoDbMetaDataMeta2CsvBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.dbmetadata.task.BlancoDbMetaDataMeta2CsvBatchProcess -help
 * </code>
 */
public class BlancoDbMetaDataMeta2CsvBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoDbMetaDataMeta2CsvBatchProcess batchProcess = new BlancoDbMetaDataMeta2CsvBatchProcess();

        // ob`̈B
        final BlancoDbMetaDataMeta2CsvProcessInput input = new BlancoDbMetaDataMeta2CsvProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldJdbcdriverProcessed = false;
        boolean isFieldJdbcurlProcessed = false;
        boolean isFieldJdbcuserProcessed = false;
        boolean isFieldJdbcpasswordProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-jdbcdriver=")) {
                input.setJdbcdriver(arg.substring(12));
                isFieldJdbcdriverProcessed = true;
            } else if (arg.startsWith("-jdbcurl=")) {
                input.setJdbcurl(arg.substring(9));
                isFieldJdbcurlProcessed = true;
            } else if (arg.startsWith("-jdbcuser=")) {
                input.setJdbcuser(arg.substring(10));
                isFieldJdbcuserProcessed = true;
            } else if (arg.startsWith("-jdbcpassword=")) {
                input.setJdbcpassword(arg.substring(14));
                isFieldJdbcpasswordProcessed = true;
            } else if (arg.startsWith("-schema=")) {
                input.setSchema(arg.substring(8));
            } else if (arg.startsWith("-table=")) {
                input.setTable(arg.substring(7));
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldJdbcdriverProcessed == false) {
            System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcdriver]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcurlProcessed == false) {
            System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcurl]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcuserProcessed == false) {
            System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcuser]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcpasswordProcessed == false) {
            System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcpassword]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoDbMetaDataMeta2CsvProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoDbMetaDataMeta2CsvProcessC^tF[X blanco.dbmetadata.taskpbP[W BlancoDbMetaDataMeta2CsvProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoDbMetaDataMeta2CsvProcess process = new BlancoDbMetaDataMeta2CsvProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoDbMetaDataMeta2CsvProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoDbMetaDataMeta2CsvBatchProcess: Usage:");
        System.out.println("  java blanco.dbmetadata.task.BlancoDbMetaDataMeta2CsvBatchProcess -verbose=l1 -jdbcdriver=l2 -jdbcurl=l3 -jdbcuser=l4 -jdbcpassword=l5 -schema=l6 -table=l7 -targetdir=l8 -tmpdir=l9");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -jdbcdriver");
        System.out.println("      [JDBChCow肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcurl");
        System.out.println("      [JDBCڑURLw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcuser");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcpassword");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -schema");
        System.out.println("      [XL[}BOraclȅꍇɂ̓[U^Kv܂B]");
        System.out.println("      ^[]");
        System.out.println("    -table");
        System.out.println("      [w肳ꂽꍇɂ́A̕\݂̂܂B]");
        System.out.println("      ^[]");
        System.out.println("    -targetdir");
        System.out.println("      [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[blanco.db]");
        System.out.println("    -tmpdir");
        System.out.println("      [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[tmp]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoDbMetaDataMeta2CsvProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getJdbcdriver() == null) {
            throw new IllegalArgumentException("BlancoDbMetaDataMeta2CsvBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcdriver]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcurl() == null) {
            throw new IllegalArgumentException("BlancoDbMetaDataMeta2CsvBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcurl]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcuser() == null) {
            throw new IllegalArgumentException("BlancoDbMetaDataMeta2CsvBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcuser]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcpassword() == null) {
            throw new IllegalArgumentException("BlancoDbMetaDataMeta2CsvBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcpassword]ɒlݒ肳Ă܂B");
        }
    }
}
