/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.dbphp.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.SQLException;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.db.BlancoDbConstantsPhp;
import blanco.db.common.message.BlancoDbCommonPluginMessage;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.resourcebundle.BlancoDbPhpResourceBundle;
import blanco.plugin.dbphp.BlancoDbPhpPlugin;
import blanco.plugin.dbphp.BlancoDbPhpPluginConstants;
import blanco.plugin.dbphp.actions.BlancoDbPhpGenerateAction;

/**
 * blancoDbGfB^ <br>
 * 
 * @author iga
 */
public class BlancoDbPhpEditor extends AbstractBlancoDbPhpEditor {
    /**
     * vOC̃\[XohB
     */
    private static final BlancoDbPhpResourceBundle fBundle = new BlancoDbPhpResourceBundle();
    private static final BlancoDbCommonPluginMessage fMsg = new BlancoDbCommonPluginMessage();

    private Composite top = null;

    // rWÄ
    private Text textBlancoDbSettingId = null;

    private Combo comboJdbcdriver = null;

    private Combo comboJdbcurl = null;

    private Combo comboJdbcuser = null;

    private Text textJdbcpassword = null;

    private Combo comboBasepackage = null;

    private Combo comboRuntimepackage = null;

    private Combo comboMetadir = null;

    private Combo comboSchema = null;

    private Combo comboSqlForm = null;

    private Button checkBoxTable = null;

    private Button checkBoxSql = null;

    private Button checkBoxLogging = null;

    private Text textStatementtimeout = null;

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelBlancoDbTitle = new Label(top, SWT.NONE);
        labelBlancoDbTitle.setText(BlancoDbConstantsPhp.PRODUCT_NAME
                + " ݒt@C GfB^ (" + BlancoDbConstantsPhp.VERSION + ")");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelBlancoDbSettingId = new Label(top, SWT.NONE);
        labelBlancoDbSettingId.setText(BlancoDbConstantsPhp.PRODUCT_NAME
                + "ݒID");
        textBlancoDbSettingId = new Text(top, SWT.BORDER);
        textBlancoDbSettingId.setText(BlancoDbConstantsPhp.PRODUCT_NAME + "ݒ");
        textBlancoDbSettingId.setEditable(false);
        Label labelJdbcdriver = new Label(top, SWT.NONE);
        labelJdbcdriver.setText("JDBChCo");
        createComboJdbcdriver();
        Label labelJdbcurl = new Label(top, SWT.NONE);
        labelJdbcurl.setText("URL");
        createComboJdbcurl();
        Label labelJdbcuser = new Label(top, SWT.NONE);
        labelJdbcuser.setText("[U");
        createComboJdbcuser();
        Label labelJdbcpassword = new Label(top, SWT.NONE);
        labelJdbcpassword.setText("pX[h");
        textJdbcpassword = new Text(top, SWT.BORDER | SWT.PASSWORD);
        Label labelBasepackage = new Label(top, SWT.NONE);
        labelBasepackage.setText("pbP[W");
        createComboBasepackage();
        Label labelRuntimepackage = new Label(top, SWT.NONE);
        labelRuntimepackage.setText("^CpbP[W");
        createComboRuntimepackage();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelPackageComment = new Label(top, SWT.NONE);
        labelPackageComment.setText("pbP[Ww肵ĂB");

        Label labelMetadir = new Label(top, SWT.NONE);
        labelMetadir.setText("^fBNg");
        createComboMetadir();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelMetadirComment = new Label(top, SWT.NONE);
        labelMetadirComment.setText("^fBNg͒ʏύXɗp܂B");

        Label labelSchema = new Label(top, SWT.NONE);
        labelSchema.setText("XL[}");
        createComboSchema();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // .classpath t@C̓ǂݍݖړIB
        final IFileEditorInput input = (IFileEditorInput) getEditorInput();
        if (input == null) {
            return;
        }
        final IFile ifileClasspath = input.getFile().getProject().getFile(
                ".classpath");
        if (ifileClasspath == null) {
            MessageDialog.openWarning(top.getShell(), fMsg.getMbdbcmc01(),
                    "vWFNgE[gɁu.classpathvt@C܂B\n"
                            + "Java vWFNgŎsĂB");
            return;
        }
        final File fileClasspath = ifileClasspath.getLocation().toFile();

        Button buttonConnectionCheck = new Button(top, SWT.NONE);
        buttonConnectionCheck.setText("ڑ`FbN");
        buttonConnectionCheck
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }
                        try {
                            checkConnectionSetting(fileClasspath,
                                    comboJdbcdriver.getText(), comboJdbcurl
                                            .getText(),
                                    comboJdbcuser.getText(), textJdbcpassword
                                            .getText(), true);
                        } catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Button buttonCreateMetafile = new Button(top, SWT.NONE);
        buttonCreateMetafile
                .setText(fBundle.getMetafileDisplayname() + " VK쐬");
        buttonCreateMetafile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetadir.getText().length() == 0) {
                            MessageDialog.openWarning(top.getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", "^fBNgw肵ĂB\n"
                                    + "^fBNg̈ʓIȐݒl 'meta/sql' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoDbPhpPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetadir.getText()).exists() == false) {
                                BlancoDbPhpPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetadir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetadir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", "^fBNg쐬Ɏs܂Bf܂B:"
                                    + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        try {
                            URL localURL = BlancoDbPhpPlugin.getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", fBundle.getMetafileDisplayname()
                                    + "(^t@C)^fBNg["
                                    + comboMetadir.getText() + "]ɍ쐬܂B"
                                    + fBundle.getMetafileDisplayname()
                                    + "̐VKt@C͂ĂB",
                                    "blancoDbPhpMeta.xls",
                                    new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetadir
                                                                    .getText())
                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            String fileName = "blancoDbTemplateDb.xls";
                            // if (comboSqlForm.getText().equals("Japanese")) {
                            // fileName = "blancoDbDotNetTemplate_ja.xls";
                            // }

                            // vOC̃[Jev[gǂݍ݂܂B
                            InputStream inStream = new FileInputStream(localURL
                                    .getPath()
                                    + "/meta/template/" + fileName);
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetadir.getText()).getFile(
                                            newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            inStream.close();
                            MessageDialog
                                    .openInformation(
                                            top.getShell(),
                                            fBundle.getMetafileDisplayname()
                                                    + " VK쐬",
                                            fBundle.getMetafileDisplayname()
                                                    + "["
                                                    + newMetaFilename
                                                    + "] ^fBNg["
                                                    + comboMetadir.getText()
                                                    + "]ɐVK쐬܂B\n"
                                                    + "̃t@CҏWāASQLъ֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Group groupSqlDef = new Group(top, SWT.NONE);
        groupSqlDef.setLayout(new FillLayout());
        groupSqlDef.setText("SQL`VK쐬IvV");
        comboSqlForm = new Combo(groupSqlDef, SWT.READ_ONLY);
        comboSqlForm.add("English");
        comboSqlForm.add("Japanese");
        comboSqlForm.select(1);
        comboSqlForm.setEnabled(false);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Button buttonExecute = new Button(top, SWT.NONE);
        buttonExecute.setText("\[XR[h");
        buttonExecute
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {

                        if (textStatementtimeout.getText().length() > 0) {
                            try {
                                Integer
                                        .parseInt(textStatementtimeout
                                                .getText());
                            } catch (NumberFormatException ex) {
                                MessageDialog.openWarning(top.getShell(),
                                        "ڂɓ͂ꂽlsł",
                                        "Xe[gg^CAEgڂւ̓͒lsłB\nl͂Ă\n"
                                                + ex.toString());
                                return;
                            }
                        }

                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }
                            if (checkConnectionSetting(fileClasspath,
                                    comboJdbcdriver.getText(), comboJdbcurl
                                            .getText(),
                                    comboJdbcuser.getText(), textJdbcpassword
                                            .getText(), false) == false) {
                                return;
                            }

                            final BlancoDbSetting dbSetting = new BlancoDbSetting();
                            dbSetting
                                    .setBasePackage(comboBasepackage.getText());
                            dbSetting.setRuntimePackage(comboRuntimepackage
                                    .getText());
                            dbSetting.setJdbcdriver(comboJdbcdriver.getText());
                            dbSetting.setJdbcurl(comboJdbcurl.getText());
                            dbSetting.setJdbcuser(comboJdbcuser.getText());
                            dbSetting.setJdbcpassword(textJdbcpassword
                                    .getText());
                            BlancoDbUtil
                                    .readClasspathEntryFromEclipseJavaProject(
                                            fileClasspath, dbSetting);

                            final String jdbcSchema = comboSchema.getText();
                            if (jdbcSchema != null && jdbcSchema.length() > 0) {
                                // XL[}wB
                                // w肪ꍇɂ̂݃Zbĝ@łB
                                dbSetting.setSchema(jdbcSchema);
                            }

                            dbSetting
                                    .setLogging(checkBoxLogging.getSelection());
                            if (BlancoStringUtil.null2Blank(
                                    textStatementtimeout.getText()).length() > 0) {
                                try {
                                    dbSetting.setStatementTimeout(Integer
                                            .parseInt(textStatementtimeout
                                                    .getText()));
                                } catch (NumberFormatException ex) {
                                    throw new IllegalArgumentException(
                                            "Xe[gg^CAEglƂĎw肳ꂽl["
                                                    + textStatementtimeout
                                                            .getText()
                                                    + "]͐lƂĉ͂ł܂łBf܂B:"
                                                    + ex.toString());
                                }
                            }

                            BlancoDbPhpGenerateAction.processBlancoDb(
                                    ((IFileEditorInput) getEditorInput())
                                            .getFile(), top.getShell(),
                                    getProgressMonitor(), comboMetadir
                                            .getText(), dbSetting,
                                    checkBoxTable.getSelection(), checkBoxSql
                                            .getSelection());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        }
                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Group group = new Group(top, SWT.NONE);
        group.setLayout(new FillLayout());
        group.setText("\[XR[hIvV");
        checkBoxTable = new Button(group, SWT.CHECK);
        checkBoxTable.setText("P\");
        checkBoxTable.setSelection(true);
        checkBoxSql = new Button(group, SWT.CHECK);
        checkBoxSql.setText("SQL`");
        checkBoxSql.setSelection(true);
        checkBoxLogging = new Button(group, SWT.CHECK);
        checkBoxLogging.setText("MO");
        checkBoxLogging.setSelection(false);
        // MO͌_ł͑ΉĂ܂B
        checkBoxLogging.setEnabled(false);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelPasswordComment = new Label(top, SWT.NONE);
        labelPasswordComment.setText(": eX̐ݒl "
                + BlancoDbPhpPluginConstants.TARGET_FILENAME
                + "t@CɕŊi[܂B");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelPasswordComment2 = new Label(top, SWT.NONE);
        labelPasswordComment2.setText("ZLeBvmFēK؂ȑΏȂĂB");

        {
            final Label labelStatementtimeout = new Label(top, SWT.NONE);
            labelStatementtimeout.setText("Xe[gg^CAEg");
            textStatementtimeout = new Text(top, SWT.BORDER);
            textStatementtimeout.setEnabled(false);
        }

        // Xy[T[
        new Label(top, SWT.NONE).setText("");
        {
            final Label labelPasswordComment3 = new Label(top, SWT.NONE);
            labelPasswordComment3.setText("Xe[gg^CAEglɂ͕bw肵܂B");
        }

        // Xy[T[
        new Label(top, SWT.NONE).setText("");
        {
            final Label labelPasswordComment3 = new Label(top, SWT.NONE);
            labelPasswordComment3.setText("SẴXe[gg̃ftHg^CAEglƂėp܂B");
        }

        loadFromTextEditor();

        // tH[JXۂ̏B
        setFocusLostHandler(comboJdbcdriver);
        setFocusLostHandler(comboJdbcurl);
        setFocusLostHandler(comboJdbcuser);
        setFocusLostHandler(textJdbcpassword);
        setFocusLostHandler(comboBasepackage);
        setFocusLostHandler(comboRuntimepackage);
        setFocusLostHandler(comboMetadir);
        setFocusLostHandler(comboSchema);
        setFocusLostHandler(comboSqlForm);
        setFocusLostHandler(checkBoxTable);
        setFocusLostHandler(checkBoxSql);
        setFocusLostHandler(checkBoxLogging);
        setFocusLostHandler(textStatementtimeout);
    }

    /**
     * ڑݒʂɐڑ\ǂ𒲂ׂ܂B
     * 
     * @throws IOException
     */
    private boolean checkConnectionSetting(final File fileClasspath,
            final String jdbcdriver, final String jdbcurl,
            final String jdbcuser, final String jdbcpassword,
            final boolean isReportSuccess) throws IOException {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            monitor.beginTask("ڑ`FbNȂ܂B", 5);
                            monitor.worked(1);
                            try {
                                final BlancoDbSetting dbSetting = new BlancoDbSetting();
                                dbSetting.setJdbcdriver(jdbcdriver);
                                dbSetting.setJdbcurl(jdbcurl);
                                dbSetting.setJdbcuser(jdbcuser);
                                dbSetting.setJdbcpassword(jdbcpassword);
                                BlancoDbUtil
                                        .readClasspathEntryFromEclipseJavaProject(
                                                fileClasspath, dbSetting);
                                BlancoDbUtil.connect(dbSetting);

                                monitor.worked(1);
                            } catch (Exception e) {
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                throw new InvocationTargetException(e, e
                                        .toString());
                            }
                        }
                    });
            if (isReportSuccess) {
                MessageDialog
                        .openInformation(top.getShell(), "ڑ`FbN",
                                "f[^x[Xւ̐ڑɐ܂.\n݂̐ݒŃf[^x[Xɐڑ\ł邱ƂmFł܂B");
            }
            return true;
        } catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                MessageDialog.openWarning(top.getShell(), fMsg.getMbdbcmc01(),
                        "ڑɎs܂B\n"
                                + "ɂ܂ݒlA[UEpX[hȂǂmFĂB\n\n"
                                + cause.toString());
            } else if (cause instanceof ClassNotFoundException) {
                MessageDialog.openWarning(top.getShell(), fMsg.getMbdbcmc01(),
                        fMsg.getMbdbcmc02(comboJdbcdriver.getText()) + "\n\n"
                                + cause.toString());
            } else {
                MessageDialog.openWarning(top.getShell(), fMsg.getMbdbcmc01(),
                        "ڑɎs܂B\n" + "z肵ȂG[܂B\n\n"
                                + cause.toString());
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void loadFromTextEditorInternal(final DOMResult argResult) {
        final Node nodeRoot = argResult.getNode();
        if (nodeRoot == null) {
            return;
        }
        final Element elementBlancoDb = BlancoXmlUtil.getElement(nodeRoot,
                "blanco/target/blancodbphp");
        if (elementBlancoDb == null) {
            return;
        }

        final String jdbcdriver = elementBlancoDb.getAttribute("jdbcdriver");
        if (jdbcdriver != null) {
            comboJdbcdriver.setText(jdbcdriver);
        }
        final String jdbcurl = elementBlancoDb.getAttribute("jdbcurl");
        if (jdbcurl != null) {
            comboJdbcurl.setText(jdbcurl);
        }
        final String jdbcuser = elementBlancoDb.getAttribute("jdbcuser");
        if (jdbcuser != null) {
            comboJdbcuser.setText(jdbcuser);
        }
        final String jdbcpassword = elementBlancoDb
                .getAttribute("jdbcpassword");
        if (jdbcpassword != null) {
            textJdbcpassword.setText(jdbcpassword);
        }
        final String basepackage = elementBlancoDb.getAttribute("basepackage");
        if (basepackage != null) {
            comboBasepackage.setText(basepackage);
        }
        final String runtimepackage = elementBlancoDb
                .getAttribute("runtimepackage");
        if (runtimepackage != null) {
            comboRuntimepackage.setText(runtimepackage);
        }
        final String metadir = elementBlancoDb.getAttribute("metadir");
        if (metadir != null) {
            comboMetadir.setText(metadir);
        }
        final String schema = elementBlancoDb.getAttribute("schema");
        if (schema != null) {
            comboSchema.setText(schema);
        }
        final String table = elementBlancoDb.getAttribute("table");
        if (table != null) {
            checkBoxTable.setSelection(table.equals("true"));
        }
        final String sql = elementBlancoDb.getAttribute("sql");
        if (sql != null) {
            checkBoxSql.setSelection(sql.equals("true"));
        }
        final String logging = elementBlancoDb.getAttribute("log");
        if (logging != null) {
            checkBoxLogging.setSelection(logging.equals("true"));
        }
        final String statementtimeout = elementBlancoDb
                .getAttribute("statementtimeout");
        if (statementtimeout != null) {
            textStatementtimeout.setText(statementtimeout);
        }
    }

    protected Document saveToTextEditorInternal() {
        String schema = null;
        if (comboSchema.getText().trim().length() > 0) {
            schema = comboSchema.getText();
        }

        String runtimepackage = null;
        if (comboRuntimepackage.getText().trim().length() > 0) {
            runtimepackage = comboRuntimepackage.getText();
        }

        final Document document = BlancoXmlUtil.newDocument();
        final Element eleBlanco = document.createElement("blanco");
        document.appendChild(eleBlanco);

        final Element eleTarget = document.createElement("target");
        eleTarget.setAttribute("name", textBlancoDbSettingId.getText());
        eleBlanco.appendChild(eleTarget);

        final Element eleBlancoDb = document.createElement("blancodbphp");
        eleTarget.appendChild(eleBlancoDb);

        eleBlancoDb.setAttribute("jdbcdriver", comboJdbcdriver.getText());
        eleBlancoDb.setAttribute("jdbcurl", comboJdbcurl.getText());
        eleBlancoDb.setAttribute("jdbcuser", comboJdbcuser.getText());
        eleBlancoDb.setAttribute("jdbcpassword", textJdbcpassword.getText());
        eleBlancoDb.setAttribute("basepackage", comboBasepackage.getText());
        if (runtimepackage != null) {
            eleBlancoDb.setAttribute("runtimepackage", runtimepackage);
        }
        eleBlancoDb.setAttribute("metadir", comboMetadir.getText());
        eleBlancoDb.setAttribute("table", checkBoxTable.getSelection() ? "true"
                : "false");
        eleBlancoDb.setAttribute("sql", checkBoxSql.getSelection() ? "true"
                : "false");
        eleBlancoDb.setAttribute("log", checkBoxLogging.getSelection() ? "true"
                : "false");
        if (schema != null) {
            eleBlancoDb.setAttribute("schema", schema);
        }
        eleBlancoDb.setAttribute("statementtimeout", textStatementtimeout
                .getText());

        return document;
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (comboJdbcdriver.getText().length() == 0) {
            comboJdbcdriver.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboJdbcdriver.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboJdbcurl.getText().length() == 0) {
            comboJdbcurl.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboJdbcurl.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboJdbcuser.getText().length() == 0) {
            comboJdbcuser.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboJdbcuser.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboBasepackage.getText().length() == 0) {
            comboBasepackage.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboBasepackage.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboMetadir.getText().length() == 0) {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    /**
     * This method initializes comboJdbcdriver
     * 
     */
    private void createComboJdbcdriver() {
        comboJdbcdriver = new Combo(top, SWT.NONE);
        comboJdbcdriver
                .addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {

                        Object source = e.getSource();
                        if (source instanceof Combo) {
                            Combo combo = (Combo) source;
                            if (combo.getText().equals(
                                    "oracle.jdbc.driver.OracleDriver")) {
                                comboJdbcurl
                                        .setText("jdbc:oracle:thin:@localhost:1521:orcl");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("SCOTT");
                                comboSchema.removeAll();
                                comboSchema.add("SCOTT");
                                comboSchema.setText("SCOTT");
                            } else if (combo
                                    .getText()
                                    .equals(
                                            "com.microsoft.sqlserver.jdbc.SQLServerDriver")) {
                                // Microsoft SQL Server 2005
                                comboJdbcurl
                                        .setText("jdbc:sqlserver://localhost");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("sa");
                                comboSchema.removeAll();
                            } else if (combo
                                    .getText()
                                    .equals(
                                            "com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
                                // Microsoft SQL Server 2000
                                comboJdbcurl
                                        .setText("jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=Northwind;SelectMethod=cursor");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("sa");
                                comboSchema.removeAll();
                            } else if (combo.getText().equals(
                                    "org.postgresql.Driver")) {
                                comboJdbcurl
                                        .setText("jdbc:postgresql://localhost:5432/");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("postgres");
                                comboSchema.removeAll();
                            } else if (combo.getText().equals(
                                    "com.mysql.jdbc.Driver")) {
                                comboJdbcurl
                                        .setText("jdbc:mysql://localhost:3306/test?useUnicode=true");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("root");
                                comboSchema.removeAll();
                            }
                        }
                    }

                    public void widgetDefaultSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                    }
                });
        comboJdbcdriver.add("org.postgresql.Driver");
        comboJdbcdriver.add("com.mysql.jdbc.Driver");
    }

    /**
     * This method initializes comboJdbcurl
     * 
     */
    private void createComboJdbcurl() {
        comboJdbcurl = new Combo(top, SWT.NONE);
    }

    /**
     * This method initializes comboJdbcuser
     * 
     */
    private void createComboJdbcuser() {
        comboJdbcuser = new Combo(top, SWT.NONE);
    }

    /**
     * This method initializes comboBasepackage
     * 
     */
    private void createComboBasepackage() {
        comboBasepackage = new Combo(top, SWT.NONE);
        comboBasepackage.add("myapp.db");
        comboBasepackage.add("mycompany.myapp.db");
        comboBasepackage.select(0);
    }

    /**
     * This method initializes comboRuntimepackage
     * 
     */
    private void createComboRuntimepackage() {
        comboRuntimepackage = new Combo(top, SWT.NONE);
        comboRuntimepackage.add("myapp.db");
        comboRuntimepackage.add("mycompany.myapp.db");
    }

    /**
     * This method initializes comboMetadir
     * 
     */
    private void createComboMetadir() {
        comboMetadir = new Combo(top, SWT.NONE);
        comboMetadir.add("meta/sql");
        comboMetadir.select(0);
    }

    /**
     * This method initializes comboSchema
     * 
     */
    private void createComboSchema() {
        comboSchema = new Combo(top, SWT.NONE);
    }
}