/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.expander.exception.NoRowFoundExceptionClassDotNet;
import blanco.db.expander.exception.TooManyRowsFoundExceptionClassDotNet;
import blanco.db.util.BlancoDbCgUtilDotNet;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * VOtruȅꍇɂ̂݁ÃNX͗p܂
 * 
 * @author Tosiki Iga
 */
public class GetSingleRowMethodDotNet extends BlancoDbAbstractMethod {
    public GetSingleRowMethodDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("GetSingleRow",
                "݂̍s̃f[^IuWFNgƂĎ擾܂B");
        fCgClass.getMethodList().add(cgMethod);

        // sIuWFNǧ^擾܂B
        final String rowObjectType = fDbSetting.getBasePackage() + ".row."
                + BlancoNameAdjuster.toClassName(fSqlInfo.getName()) + "Row";

        cgMethod.setReturn(fCgFactory.createReturn(rowObjectType, "sIuWFNg"));

        // cgMethod.getThrowList().add(
        // fCgFactory.createException(BlancoDbUtil
        // .getRuntimePackage(fDbSetting)
        // + ".exception.NoRowFoundException",
        // "f[^x[X̏̌ʁA1sf[^ȂꍇB"));
        // cgMethod.getThrowList().add(
        // fCgFactory.createException(BlancoDbUtil
        // .getRuntimePackage(fDbSetting)
        // + ".exception.TooManyRowsFoundException",
        // "f[^x[X̏̌ʁA1s𒴂f[^Ă܂ꍇB"));

        BlancoDbCgUtilDotNet.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        final List<String> listDesc = cgMethod.getLangDoc()
                .getDescriptionList();

        listDesc.add("̃\bh𗘗pꍇɂ́ANext()Ȃǂ̃J[\𑀍삷郁\bhƂ͕pȂłB");
        listDesc.add("");
        listDesc.add("singleL");
        listDesc.add("ʂ1ȊȌꍇɂ́ANotSingleRowExceptionNX");
        listDesc.add("hNX̗O܂B");

        final List<String> listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            BlancoDbCgUtilDotNet.addBeginLogToMethod(cgMethod);
        }

        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting) + ".exception."
                        + NoRowFoundExceptionClassDotNet.CLASS_NAME);

        listLine.add("if (Next() == false) {");
        listLine.add("throw new NoRowFoundException(\"sł܂łB\");");
        listLine.add("}");
        listLine.add("");

        listLine.add(BlancoNameUtil.trimJavaPackage(rowObjectType)
                + " result = GetRow();");
        listLine.add("");

        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting) + ".exception."
                        + TooManyRowsFoundExceptionClassDotNet.CLASS_NAME);

        // 1s𒴂ĕύXǂ`FbNB
        listLine.add("if (Next()) {");
        listLine
                .add("throw new TooManyRowsFoundException(\"1ȏ̍s܂B\");");
        listLine.add("}");
        listLine.add("");

        listLine.add("return result;");
    }
}