/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.jsf.valueobject.BlancoJsfBeanItemStructure;
import blanco.jsf.valueobject.BlancoJsfStructure;

/**
 * (blancoJsf)̂߂̃CNXB
 * 
 * C^tF[XWJ܂B
 */
class BlancoJsfExpandLogic {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgInterface fCgInterface = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void expandSourceFile(final BlancoJsfStructure argProcessStructure,
            final List<String> sqlClassNameList, final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), null);
        fCgSourceFile.setEncoding(fEncoding);
        fCgInterface = fCgFactory.createInterface(
                getProcessInterfaceName(argProcessStructure), BlancoStringUtil
                        .null2Blank(argProcessStructure.getDescription()));
        fCgSourceFile.getInterfaceList().add(fCgInterface);

        fCgInterface.setDescription(" ["
                + getProcessInterfaceName(argProcessStructure) + "]C^tF[XB");
        fCgInterface.getLangDoc().getDescriptionList().add(
                "̃C^tF[Xp [" + argProcessStructure.getPackage()
                        + "]pbP[W["
                        + getProcessInterfaceName(argProcessStructure)
                        + "]NX쐬Ďۂ̃ob`ĂB<br>");
        fCgInterface.getLangDoc().getDescriptionList().add("");

        expandMethodExecute(argProcessStructure, sqlClassNameList);

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * execute \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodExecute(
            final BlancoJsfStructure argProcessStructure,
            final List<String> sqlClassNameList) {
        final BlancoCgMethod method = fCgFactory.createMethod("execute",
                "NXCX^Xďsۂ̃Gg|CgłB");
        fCgInterface.getMethodList().add(method);
        method.setFinal(true);

        for (BlancoJsfBeanItemStructure bean : argProcessStructure
                .getBeanList()) {
            // TODO ́AóAo͂ւ̑ΉB
            String name = BlancoNameUtil.trimJavaPackage(bean.getName());
            method.getParameterList().add(
                    fCgFactory.createParameter("arg" + name, bean.getName(),
                            "̓̓p[^B"));
        }

        // TODO SQL ̏ΉB
        for (String sqlClassName : sqlClassNameList) {
            String name = BlancoNameUtil.trimJavaPackage(sqlClassName);
            method.getParameterList().add(
                    fCgFactory.createParameter("arg" + name, sqlClassName,
                            "̓̓p[^B"));
        }

        if (argProcessStructure.getForward()) {
            // ߂lȂ String
            method.setReturn(fCgFactory.createReturn("java.lang.String",
                    "̎sʁBsuccess, error Ȃǂ̑JڐɊւ镶ԋpB"));
        }

        method.getThrowList().add(
                fCgFactory.createException("java.io.IOException",
                        "o͗OꍇB"));
        method.getThrowList().add(
                fCgFactory
                        .createException("java.lang.IllegalArgumentException",
                                "͒lɕsꍇB"));
    }

    private String getProcessInterfaceName(final BlancoJsfStructure argStructure) {
        return BlancoNameAdjuster.toClassName(argStructure.getName())
                + argStructure.getSuffix();
    }
}
