/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.jsf.valueobject.BlancoJsfBeanItemStructure;
import blanco.jsf.valueobject.BlancoJsfStructure;

/**
 * (blancoJsf)̂߂̃vLVENXB
 */
class BlancoJsfExpandLogicProxy {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void expandSourceFile(final BlancoJsfStructure argProcessStructure,
            final List<String> sqlClassNameList, final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), null);
        fCgSourceFile.setEncoding(fEncoding);
        fCgClass = fCgFactory.createClass(
                getProcessInterfaceName(argProcessStructure), BlancoStringUtil
                        .null2Blank(argProcessStructure.getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.setDescription(" ["
                + getProcessInterfaceName(argProcessStructure) + "]C^tF[XB");
        fCgClass.getLangDoc().getDescriptionList().add(
                "̃C^tF[Xp [" + argProcessStructure.getPackage()
                        + "]pbP[W["
                        + getProcessInterfaceName(argProcessStructure)
                        + "]NX쐬Ďۂ̃ob`ĂB<br>");
        fCgClass.getLangDoc().getDescriptionList().add("");

        fCgSourceFile.getImportList().add("javax.el.ELContext");
        fCgSourceFile.getImportList().add("javax.el.ELResolver");
        fCgSourceFile.getImportList().add("javax.faces.context.FacesContext");

        expandMethodExecute(argProcessStructure, sqlClassNameList);

        if (argProcessStructure.getForward()) {
            final BlancoCgField field = fCgFactory.createField("fOutcome",
                    "java.lang.String", "ʁB");
            field.setDefault("\"error\"");
            fCgClass.getFieldList().add(field);

            expandMethodOutcome(argProcessStructure);
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * execute \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodExecute(
            final BlancoJsfStructure argProcessStructure,
            final List<String> sqlClassNameList) {
        final BlancoCgMethod method = fCgFactory.createMethod("execute",
                "NXCX^Xďsۂ̃Gg|CgłB");
        fCgClass.getMethodList().add(method);
        method.setFinal(true);

        method.getParameterList().add(
                fCgFactory.createParameter("event",
                        "javax.faces.event.ActionEvent", "CxgB"));

        method.getLineList().add(
                "final FacesContext ctx = FacesContext.getCurrentInstance();");
        method.getLineList().add("final ELContext elc = ctx.getELContext();");
        method
                .getLineList()
                .add(
                        "final ELResolver rslvr = ctx.getApplication().getELResolver();");

        method.getLineList().add("");

        for (BlancoJsfBeanItemStructure bean : argProcessStructure
                .getBeanList()) {
            final String classname = BlancoNameUtil.trimJavaPackage(bean
                    .getName());
            method.getLineList().add(
                    "// Managed Bean ["
                            + BlancoNameAdjuster.toLowerCaseTitle(classname)
                            + "] 擾܂B");
            fCgSourceFile.getImportList().add(bean.getName());
            method.getLineList().add(
                    BlancoNameUtil.trimJavaPackage(bean.getName()) + " arg"
                            + classname + " = ("
                            + BlancoNameUtil.trimJavaPackage(bean.getName())
                            + ") rslvr.getValue(elc, null, \""
                            + BlancoNameAdjuster.toLowerCaseTitle(classname)
                            + "\");");
        }
        method.getLineList().add("");

        if (argProcessStructure.getSqlList().size() > 0) {
            addUtilImport(argProcessStructure);
            fCgSourceFile.getImportList().add("java.sql.Connection");
            method
                    .getLineList()
                    .add(
                            "final Connection conn = BlancoJsfProxyUtil.getConnection();");
            method.getLineList().add("boolean isLogicSuccess = false;");
        }

        for (String sqlClassName : sqlClassNameList) {
            fCgSourceFile.getImportList().add(sqlClassName);
            method.getLineList().add(
                    BlancoNameUtil.trimJavaPackage(sqlClassName) + " arg"
                            + BlancoNameUtil.trimJavaPackage(sqlClassName)
                            + " = new "
                            + BlancoNameUtil.trimJavaPackage(sqlClassName)
                            + "(conn);");
            method.getLineList().add("");
        }

        method.getLineList().add(
                "// ȉ̃R[hŃRpCEG[ꍇɂ́ANX ["
                        + argProcessStructure.getPackage()
                        + "."
                        + BlancoNameAdjuster.toClassName(argProcessStructure
                                .getName()) + argProcessStructure.getSuffix()
                        + "Impl] VKɍ쐬ĂB");
        method.getLineList().add(
                "final "
                        + BlancoNameAdjuster.toClassName(argProcessStructure
                                .getName())
                        + argProcessStructure.getSuffix()
                        + " logic = new "
                        + BlancoNameAdjuster.toClassName(argProcessStructure
                                .getName()) + argProcessStructure.getSuffix()
                        + "Impl();");

        {
            final StringBuffer buf = new StringBuffer();
            boolean isFirst = true;
            for (BlancoJsfBeanItemStructure bean : argProcessStructure
                    .getBeanList()) {
                final String classname = BlancoNameUtil.trimJavaPackage(bean
                        .getName());
                if (isFirst == false) {
                    buf.append(", ");
                } else {
                    isFirst = false;
                }
                buf.append("arg" + classname);
            }
            for (String sql : sqlClassNameList) {
                final String classname = BlancoNameUtil.trimJavaPackage(sql);
                if (isFirst == false) {
                    buf.append(", ");
                } else {
                    isFirst = false;
                }
                buf.append("arg" + classname);
            }

            method.getLineList().add("");
            method.getLineList().add("try {");
            {
                String line = "logic.execute(" + buf.toString() + ");";
                if (argProcessStructure.getForward()) {
                    line = "fOutcome = " + line;
                }
                method.getLineList().add(line);

                if (argProcessStructure.getSqlList().size() > 0) {
                    method.getLineList().add("conn.commit();");
                    method.getLineList().add("isLogicSuccess = true;");
                }
            }
            method.getLineList().add("} catch (Exception ex) {");
            method.getLineList().add("ex.printStackTrace();");
            method.getLineList().add("}");

            if (argProcessStructure.getSqlList().size() > 0) {
                method.getLineList().add("");
                method.getLineList().add("if (isLogicSuccess == false) {");
                method.getLineList().add("try {");
                method.getLineList().add("conn.rollback();");
                method.getLineList().add("} catch (Exception ex) {");
                method.getLineList().add("ex.printStackTrace();");
                method.getLineList().add("}");
                method.getLineList().add("}");
                method.getLineList().add("// RlNV̊JB");
                method.getLineList().add(
                        "BlancoJsfProxyUtil.releaseConnection(conn);");
            }
        }
    }

    private void expandMethodOutcome(
            final BlancoJsfStructure argProcessStructure) {
        final BlancoCgMethod method = fCgFactory.createMethod("outcome",
                "sʂ擾B");
        fCgClass.getMethodList().add(method);
        method.setFinal(true);
        method.setReturn(fCgFactory.createReturn("java.lang.String", "ʏB"));
        method.getLineList().add("return fOutcome;");
    }

    private String getProcessInterfaceName(final BlancoJsfStructure argStructure) {
        return BlancoNameAdjuster.toClassName(argStructure.getName())
                + argStructure.getSuffix() + "Proxy";
    }

    /**
     * DB  getConnection KvȏꍇɗpB
     * 
     * @param argProcessStructure
     */
    private void addUtilImport(final BlancoJsfStructure argProcessStructure) {
        fCgSourceFile.getImportList().add(
                argProcessStructure.getPackage() + ".BlancoJsfProxyUtil");
    }
}
