/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.batchprocess;

import java.io.File;

import blanco.batchprocess.stringgroup.BlancoBatchProcessSupportedLangStringGroup;
import blanco.batchprocess.valueobject.BlancoBatchProcessStructure;
import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;

/**
 * (blancoProcess)̂߂̃CNXB
 * 
 * C^tF[XWJ܂B
 */
class BlancoBatchProcessExpandProcess {
    /**
     * o͑ΏۂƂȂvO~OB
     */
    private int fTargetLang = BlancoBatchProcessSupportedLangStringGroup.NOT_DEFINED;

    /**
     * ^CpbP[WB
     */
    private String fRuntimePackage = null;

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgInterface fCgInterface = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void expandSourceFile(
            final BlancoBatchProcessStructure argProcessStructure,
            final String argRuntimePackage, final int argTargetLang,
            final File argDirectoryTarget) {
        fRuntimePackage = argRuntimePackage;
        fTargetLang = argTargetLang;

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), null);
        fCgSourceFile.setEncoding(fEncoding);
        fCgInterface = fCgFactory.createInterface(
                getProcessInterfaceName(argProcessStructure), BlancoStringUtil
                        .null2Blank(argProcessStructure.getDescription()));
        fCgSourceFile.getInterfaceList().add(fCgInterface);

        fCgInterface.setAccess("");

        fCgInterface.setDescription(" ["
                + getProcessInterfaceName(argProcessStructure) + "]C^tF[XB");
        fCgInterface.getLangDoc().getDescriptionList().add(
                "̃C^tF[Xp [" + argProcessStructure.getPackage()
                        + "]pbP[W["
                        + getProcessInterfaceName(argProcessStructure)
                        + "]NX쐬Ďۂ̃ob`ĂB<br>");
        fCgInterface.getLangDoc().getDescriptionList().add("");

        expandMethodExecute(argProcessStructure);

        expandMethodProgress();

        {
            final BlancoBatchProcessExpandProcessInput expandProcessInput = new BlancoBatchProcessExpandProcessInput();
            expandProcessInput.setEncoding(fEncoding);
            expandProcessInput.expandSourceFile(argProcessStructure,
                    argDirectoryTarget);
        }

        if (BlancoStringUtil.null2Blank(
                argProcessStructure.getOutput().getEndBatchProcessException())
                .length() > 0) {
            // ob`OI̒lݒ肳Ăꍇɂ̂ݐ܂B

            fCgSourceFile.getImportList().add(
                    getBatchProcessExceptionClassName(argProcessStructure));

            if (BlancoStringUtil.null2Blank(fRuntimePackage).length() == 0) {
                // `ƂɓpbP[WɃ^CNX𐶐B
                new BlancoBatchProcessExpandException().expandSourceFile(
                        argProcessStructure.getPackage(), fTargetLang,
                        argDirectoryTarget);
            } else {
                // ^CpbP[Ww肪̂ŁAw̃^CpbP[WɃNX𐶐B
                new BlancoBatchProcessExpandException().expandSourceFile(
                        fRuntimePackage, fTargetLang, argDirectoryTarget);
            }
        }

        switch (fTargetLang) {
        case BlancoBatchProcessSupportedLangStringGroup.JAVA:
            BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                    fCgSourceFile, fileBlancoMain);
            break;
        default:
            break;
        }
    }

    /**
     * execute \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodExecute(
            final BlancoBatchProcessStructure argProcessStructure) {
        final BlancoCgMethod method = fCgFactory.createMethod("execute",
                "NXCX^Xďsۂ̃Gg|CgłB");
        fCgInterface.getMethodList().add(method);
        method.setFinal(true);

        method
                .getParameterList()
                .add(
                        fCgFactory
                                .createParameter(
                                        "input",
                                        argProcessStructure.getPackage()
                                                + ".valueobject."
                                                + BlancoBatchProcessExpandProcessInput
                                                        .getBatchProcessValueObjectInputClassName(argProcessStructure),
                                        "̓̓p[^B"));
        method.setReturn(fCgFactory.createReturn("int", "̎sʁB"));
        method.getThrowList().add(
                fCgFactory.createException("java.io.IOException",
                        "o͗OꍇB"));
        method.getThrowList().add(
                fCgFactory
                        .createException("java.lang.IllegalArgumentException",
                                "͒lɕsꍇB"));
    }

    /**
     * execute \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodProgress() {
        final BlancoCgMethod method = fCgFactory.createMethod("progress",
                "̒ŃACe邽тɐi񍐂ƂăR[obN܂B");
        fCgInterface.getMethodList().add(method);
        method.setFinal(true);

        method.getParameterList().add(
                fCgFactory.createParameter("argProgressMessage",
                        "java.lang.String", "ݏĂACeɊւ郁bZ[WB"));
        method.setReturn(fCgFactory.createReturn("boolean",
                "̂܂܌pꍇ falseBfNGXgꍇ trueB"));
    }

    /**
     * o͐ƂȂ鏈C^tF[X擾܂B
     * 
     * @param argProcessStructure
     * @return
     */
    static String getProcessInterfaceName(
            final BlancoBatchProcessStructure argProcessStructure) {
        return BlancoNameAdjuster.toClassName(argProcessStructure.getName())
                + "Process";
    }

    /**
     * ob`ONX擾܂B
     * 
     * @param argProcessStructure
     * @return
     */
    String getBatchProcessExceptionClassName(
            final BlancoBatchProcessStructure argProcessStructure) {
        if (BlancoStringUtil.null2Blank(
                argProcessStructure.getOutput().getEndBatchProcessException())
                .length() == 0) {
            throw new IllegalArgumentException(
                    "ob`OIOFFł̂ɁABlancoBatchProcessException NX擾̃\bhĂяo܂BĂ܂");
        }

        if (BlancoStringUtil.null2Blank(fRuntimePackage).length() == 0) {
            return argProcessStructure.getPackage()
                    + ".BlancoBatchProcessException";
        } else {
            return fRuntimePackage + ".BlancoBatchProcessException";
        }
    }
}
