package blanco.pdf;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;

import junit.framework.TestCase;
import blanco.pdf.font.BlancoPdfFontUtil;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;

public class BlancoPdfWriterTest extends TestCase {

    public void testBlancoPdfWriter() throws Exception {
        new File("tmp").mkdirs();

        final BlancoPdfPageDef pageDef = new BlancoPdfPageDef();

        final BlancoPdfWriter writer = new BlancoPdfWriter(pageDef,
                new FileOutputStream("tmp/abc.pdf"));
        writer.getPdfSetting().setConfPath("test/conf/pdf");

        final BaseFont bf = BlancoPdfFontUtil.getFont(writer.getPdfSetting(),
                "gothic10");

        writer.getPdfSetting().setColorText(Color.RED);
        writer.drawText(PdfContentByte.ALIGN_LEFT, 30, 30, "", bf, 30);
        writer.getPdfSetting().setLineDash(new float[] { 3, 3 });
        writer.getPdfSetting().setColorStroke(Color.YELLOW);
        writer.drawLine(30, 30, 50, 50);

        writer.newPage();
        writer.drawText(PdfContentByte.ALIGN_LEFT, 30, 30, "", bf, 30);

        writer.close();
    }
}
