package blanco.pdf.font;

import java.io.File;

import junit.framework.TestCase;
import blanco.pdf.font.valueobject.BlancoPdfFontDef;
import blanco.pdf.valueobject.BlancoPdfSetting;

public class BlancoPdfFontUtilTest extends TestCase {
    public void testTate() throws Exception {
        final BlancoPdfSetting setting = new BlancoPdfSetting();
        setting.setConfPath("test/conf/pdf");

        final File root = new File("test/conf/pdf/font");
        for (File look : root.listFiles()) {
            if (look == null) {
                continue;
            }
            if (look.isDirectory()) {
                continue;
            }
            if (look.getName().endsWith(".xml") == false) {
                continue;
            }

            final BlancoPdfFontDef fontDef = BlancoPdfFontUtil.read(setting,
                    look.getName().substring(0,
                            look.getName().length() - ".xml".length()));
            System.out.println(fontDef.toString());
        }
    }
}
