package blanco.pdf.page;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import junit.framework.TestCase;
import blanco.pdf.page.valueobject.BlancoPdfItemDef;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.report.BlancoPdfReport;
import blanco.pdf.valueobject.BlancoPdfSetting;

public class BlancoPdfPageUtilTest extends TestCase {
    public void testTate() throws Exception {
        new File("tmp").mkdirs();

        final File root = new File("test/conf/pdf/page");
        for (File look : root.listFiles()) {
            if (look == null) {
                continue;
            }
            if (look.isDirectory()) {
                continue;
            }

            if (look.getName().endsWith(".xml") == false) {
                continue;
            }

            BlancoPdfPageDef pageDef = null;
            {
                // TODO }`tH[ΉB
                final BlancoPdfSetting setting = new BlancoPdfSetting();
                setting.setConfPath("test/conf/pdf");
                pageDef = BlancoPdfPageUtil.read(setting,
                        look.getName().substring(0,
                                look.getName().length() - ".xml".length()));
            }

            final OutputStream outStream = new BufferedOutputStream(
                    new FileOutputStream("tmp/" + pageDef.getName() + ".pdf"));
            final BlancoPdfReport report = new BlancoPdfReport("test/conf/pdf",
                    pageDef, outStream);

            report.drawGridSheet();

            report.drawTextGrid(0, 2, "1234567890", "gothic10");
            report.drawTextGrid(0, 3, "1234567890", "gothic10ja");
            report.drawTextGrid(0, 4, "1234567890", "gothic10");
            report.drawTextGrid(0, 5, "1234567890", "gothic10");
            report.drawTextGrid(0, 6, "B", "gothic10ja");
            report.drawTextGrid(0, 7, "abcdefghijklmnopqrstuvwxyz", "gothic10");
            report.drawTextGrid(0, 8, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "gothic10");
            report.drawTextGrid(0, 9, "abcdefghijklmnopqrstuvwxyz",
                    "gothic10ja");
            report.drawTextGrid(0, 10, "", "gothic10ja");
            report
                    .drawTextGrid(
                            0,
                            11,
                            "MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM",
                            "gothic10");

            report.nextPage();
            report.drawGridSheet();

            report.close();
            outStream.close();
        }
    }

    public void testAAA() throws Exception {
        new File("tmp").mkdirs();

        final BlancoPdfPageDef page = new BlancoPdfPageDef();
        final BlancoPdfItemDef item = new BlancoPdfItemDef();
        item.setName("aaa");
        page.getItemList().add(item);

        final JAXBContext context = JAXBContext
                .newInstance(BlancoPdfPageDef.class);
        final Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(page, new File("tmp/aaa.xml"));
    }
}
