/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.report;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

import blanco.pdf.BlancoPdfWriter;
import blanco.pdf.font.BlancoPdfFontUtil;
import blanco.pdf.font.valueobject.BlancoPdfFontDef;
import blanco.pdf.page.valueobject.BlancoPdfItemDef;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;

public class BlancoPdfReport {
    protected Map<String, BaseFont> fFontMap = new HashMap<String, BaseFont>();

    protected BlancoPdfPageDef fPageDef = null;
    protected BlancoPdfWriter fWriter = null;

    public BlancoPdfReport(final String confPath,
            final BlancoPdfPageDef pageDef, final OutputStream outStream) {
        fPageDef = pageDef;

        // TODO C^[̍쐬́Ã^C~ODK?
        // TODO t@C͊O^B
        fWriter = new BlancoPdfWriter(pageDef, outStream);
        fWriter.getPdfSetting().setConfPath(confPath);
    }

    public void close() {
        try {
            fWriter.close();
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("N[YɗO", e);
        }
    }

    /**
     * [݌vp̃Obh`B
     * 
     * @param writer
     */
    public void drawGridSheet() {
        fWriter.getPdfSetting().setPageRotate(fPageDef.getRotate());
        // FIXME }[WړĂ܂(!)
        fWriter.getPageDef().setMarginX(fPageDef.getPitchX() * 2);
        // FIXME }[WړĂ܂(!)
        fWriter.getPageDef().setMarginY(fPageDef.getPitchX() * 2);

        fWriter.getPdfSetting().setLineWidth(0.1f);
        fWriter.drawLine(-10, -10, fPageDef.getColumn() * fPageDef.getPitchX(),
                -10);
        fWriter.drawLine(-10, -10, -10, fPageDef.getRow()
                * fPageDef.getPitchY());

        fWriter
                .drawLine(-10, 0, fPageDef.getColumn() * fPageDef.getPitchX(),
                        0);
        fWriter.drawLine(0, -10, 0, fPageDef.getRow() * fPageDef.getPitchY());

        for (int x = 0; x <= fPageDef.getColumn(); x++) {
            fWriter.getPdfSetting().setLineWidth(0.1f);
            int length = 3;
            if (x % 5 == 0) {
                length = 5;
            }
            if (x % 10 == 0) {
                length = 2;
                fWriter.getPdfSetting().setLineWidth(1f);
            }
            fWriter.drawLine(x * fPageDef.getPitchX(), -length, x
                    * fPageDef.getPitchX(), 0);
        }

        for (int y = 0; y <= fPageDef.getRow(); y++) {
            fWriter.getPdfSetting().setLineWidth(0.1f);
            int length = 3;
            if (y % 3 == 0) {
                length = 5;
            }
            if (y % 6 == 0) {
                length = 2;
                fWriter.getPdfSetting().setLineWidth(1f);
            }
            fWriter.drawLine(-length, y * fPageDef.getPitchY(), 0, y
                    * fPageDef.getPitchY());
        }

        final BaseFont bf = getFont("gothic10");

        // BB
        for (int x = 0; x <= fPageDef.getColumn() / 10; x++) {
            fWriter.drawText(PdfContentByte.ALIGN_LEFT, x
                    * fPageDef.getPitchX() * 10 - fPageDef.getPitchX() / 2, -3,
                    String.valueOf(x), bf, 8);
        }

        // BcB
        for (int y = 0; y <= fPageDef.getRow() / 6; y++) {
            fWriter.drawText(PdfContentByte.ALIGN_LEFT,
                    -fPageDef.getPitchX() - 2, y * fPageDef.getPitchY() * 6,
                    String.valueOf(y), bf, 8);
        }

        // _
        for (int x = 1; x <= fPageDef.getColumn(); x++) {
            for (int y = 1; y <= fPageDef.getRow(); y++) {
                fWriter.getPdfSetting().setColorFill(Color.BLACK);
                fWriter.drawCircle(x * fPageDef.getPitchX(), y
                        * fPageDef.getPitchY(), 0.3f);
            }
        }

        // ڂQlƂĈ󎚁B
        for (BlancoPdfItemDef itemDef : fPageDef.getItemList()) {
            final StringBuilder builder = new StringBuilder();
            for (int index = 0; index < itemDef.getLength(); index++) {
                if (itemDef.getDoubleByte() == false) {
                    builder.append("M");
                } else {
                    builder.append("");
                }
            }

            drawTextGrid(itemDef.getColumn(), itemDef.getRow(), builder
                    .toString(), itemDef.getFont());
        }
    }

    /**
     * tHg擾܂B
     * 
     * @param fontName
     * @return
     */
    public BaseFont getFont(final String fontName) {
        final BaseFont check = fFontMap.get(fontName);
        if (check == null) {
            final BaseFont bf = BlancoPdfFontUtil.getFont(fWriter
                    .getPdfSetting(), "gothic10");
            fFontMap.put(fontName, bf);
        }
        return fFontMap.get(fontName);
    }

    /**
     * w̃ObhӏɃeLXgo͂܂B
     * 
     * @param column
     * @param row
     * @param value
     * @param fontName
     */
    public void drawTextGrid(final int column, final int row,
            final String value, final String fontName) {
        final BlancoPdfFontDef font = BlancoPdfFontUtil.read(fWriter
                .getPdfSetting(), fontName);
        drawText(column * fPageDef.getPitchX(), row * fPageDef.getPitchY()
                - font.getDescent(), value, fontName);
    }

    /**
     * eLXg`悵܂B
     * 
     * @param x
     * @param y
     * @param value
     * @param fontSize
     */
    public void drawText(final float x, final float y, final String value,
            final String fontName) {
        float delta = 0;
        for (int index = 0; index < value.length(); index++) {
            final String look = String.valueOf(value.charAt(index));

            boolean isDoubleWidth = false;
            try {
                if (look.getBytes("Windows-31J").length > 1) {
                    isDoubleWidth = true;
                }
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }

            final BaseFont bf = getFont(fontName);
            final BlancoPdfFontDef font = BlancoPdfFontUtil.read(fWriter
                    .getPdfSetting(), fontName);

            fWriter.drawText(PdfContentByte.ALIGN_CENTER, x + delta
                    + fPageDef.getPitchX() / (isDoubleWidth ? 1 : 2), y
                    + fPageDef.getPitchY(), look, bf, font.getSize());
            delta += fPageDef.getPitchX();
            if (isDoubleWidth) {
                delta += fPageDef.getPitchX();
            }
        }
    }

    /**
     * y[Wɐi݂܂B
     */
    public void nextPage() {
        fWriter.newPage();
        // TODO y[W̐ݒ𔽉fAtemplate PDF Kp肷鏈B
    }
}
