/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.sample.pdf.report;

import java.io.OutputStream;
import java.util.List;

import blanco.pdf.page.BlancoPdfPageUtil;
import blanco.pdf.page.BlancoPdfPageWriter;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.valueobject.BlancoPdfSetting;
import blanco.sample.pdf.report.items.Tate01PdfReportItems;

import com.lowagie.text.pdf.PdfWriter;

/**
 * PDF |[gB
 */
public class Tate01PdfReport {
    /**
     * y[W`IuWFNgB
     */
    private BlancoPdfPageDef fPageDef;

    /**
     * y[WEC^[EIuWFNgB
     */
    private BlancoPdfPageWriter fPageWriter;

    /**
     * 1 y[W̃f[^Zbg܂B
     *
     * @param pdfSetting PDF ڌQB
     * @param outStream o̓Xg[B
     */
    public Tate01PdfReport(final BlancoPdfSetting pdfSetting, final OutputStream outStream) {
        fPageDef = BlancoPdfPageUtil.read(pdfSetting, "tate01");
        fPageWriter = new BlancoPdfPageWriter(pdfSetting.getConfPath(), fPageDef, outStream);
    }

    /**
     * 1 y[W̃f[^ PDF ɏo܂B
     *
     * @param pdfItems PDF ڌQB
     */
    public void writeItems(final Tate01PdfReportItems pdfItems) {
    }

    /**
     * y[Wׂďo͂܂B
     *
     * @param itemsList o͂ڌQB
     */
    public void writeItemsList(final List<Tate01PdfReportItems> itemsList) {
        boolean isFirst = true;
        for (Tate01PdfReportItems items : itemsList) {
            if (isFirst) {
                isFirst = false;
            } else {
                nextPage();
            }
            writeItems(items);
        }
    }

    /**
     * y[W܂B
     */
    public void nextPage() {
        fPageWriter.nextPage();
    }

    /**
     * K̎{By[Wu[NȂǂ̏Ȃ܂B
     *
     * @param itemsList KڌQB
     */
    public void normalize(final List<Tate01PdfReportItems> itemsList) {
        consolidatePage(itemsList);
        breakPageByRowCount(itemsList);
        processPageContinuity(itemsList);
        omitDitto(itemsList);

        // y[W֘A̖ߍ݁B
        applyPageNo(itemsList);
    }

    /**
     * y[W̏W񏈗Ȃ܂BׂĂ̍ڂ̒lƂɏ̂łB
     *
     * @param itemsList y[WW񂵂ڌQB
     */
    public void consolidatePage(final List<Tate01PdfReportItems> itemsList) {
        Tate01PdfReportItems prev = null;
        for (int index = 0; index < itemsList.size(); index++) {
            final Tate01PdfReportItems next = itemsList.get(index);
            if (prev == null) {
                prev = next;
                continue;
            }

            // ڂ̒lrB
            if (canConsolidatePage(prev, next)) {
                // y[WW񂵂܂B
            } else {
                prev = next;
            }
        }
    }

    /**
     * y[WWł邩ǂ`FbNB
     *
     * @param prev rB
     * @param next rB
     * @return Wł邩ǂB
     */
    public boolean canConsolidatePage(final Tate01PdfReportItems prev, final Tate01PdfReportItems next) {
        return true;
    }

    /**
     * ̍sƂɃy[Wu[N܂Bł̓y[W𕪊܂B
     *
     * @param itemsList u[NڌQB
     */
    public void breakPageByRowCount(final List<Tate01PdfReportItems> itemsList) {
    }

    /**
     * y[W̌pɊւ鏈{܂B
     *
     * @param itemsList ΏہB
     */
    public void processPageContinuity(final List<Tate01PdfReportItems> itemsList) {
    }

    /**
     * y[Wԍt^B
     *
     * @param itemsList y[WڌQB
     */
    public void applyPageNo(final List<Tate01PdfReportItems> itemsList) {
    }

    /**
     * ㍀ڂ̏ȗ{B
     *
     * @param itemsList ȗڌQB
     */
    public void omitDitto(final List<Tate01PdfReportItems> itemsList) {
    }

    /**
     * ObhEV[g`悵܂B
     */
    public void drawGridSheet() {
        fPageWriter.drawGridSheet();
    }

    /**
     * N[Y܂B
     */
    public void close() {
        fPageWriter.close();
    }

    /**
     * PDF C^[擾܂B
     *
     * @return IɗpĂ郉C^[B
     */
    @Deprecated
    public PdfWriter getPdfWriter() {
        return fPageWriter.getWriter();
    }
}
