/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.report.task;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;

class BlancoPdfReportGenerateOmitDitto {
    void omitDitto(final BlancoPdfPageDef pageDef,
            final BlancoCgObjectFactory cgFactory,
            final BlancoCgSourceFile cgSourceFile, final BlancoCgClass cgClass) {
        final BlancoCgMethod method = cgFactory.createMethod("omitDitto",
                "㍀ڂ̏ȗ{B");
        cgClass.getMethodList().add(method);
        method.getParameterList().add(
                cgFactory.createParameter("itemsList", "java.util.List<"
                        + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReportItems>", "ȗڌQB"));
        method.getLineList().add("");
    }
}
