package blanco.plugin.pdf.editors;

import java.io.PrintWriter;
import java.io.StringWriter;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import blanco.commons.util.BlancoXmlUtil;
import blanco.pdf.BlancoPdfConstants;
import blanco.pdf.resourcebundle.BlancoPdfResourceBundle;
import blanco.plugin.pdf.BlancoPdfPluginConstants;
import blanco.plugin.pdf.actions.BlancoPdfGenerateAction;

/**
 * GfB^ <br>
 * 
 * @author iga
 */
public class BlancoPdfEditor extends AbstractBlancoPdfEditor {
    private static final BlancoPdfResourceBundle fBundle = new BlancoPdfResourceBundle();

    private Composite top = null;

    // rWÄ
    private Label labelBlancoTitle = null;

    private Label labelBlancoSettingId = null;

    private Text textBlancoSettingId = null;

    // TODO ݎgpłĂȂB
    private Combo comboRuntimePackage = null;

    private Label labelConfdir = null;

    private Text textConfdir = null;

    private Label labelMetadirComment = null;

    private Label labelSettingComment = null;

    private Button buttonExecuteGenerateCheckPdf = null;

    private Button buttonExecuteJavaSource = null;

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoTitle = new Label(top, SWT.NONE);
        labelBlancoTitle.setText(BlancoPdfConstants.PRODUCT_NAME
                + " ݒt@C GfB^ (" + BlancoPdfConstants.VERSION + ")");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoSettingId = new Label(top, SWT.NONE);
        labelBlancoSettingId.setText("ݒID");
        textBlancoSettingId = new Text(top, SWT.BORDER);
        textBlancoSettingId.setText(BlancoPdfConstants.PRODUCT_NAME);
        textBlancoSettingId.setEditable(false);

        final Label labelRuntimePackage = new Label(top, SWT.NONE);
        labelRuntimePackage.setText("^CpbP[W");
        createComboRuntimePackage();

        labelConfdir = new Label(top, SWT.NONE);
        labelConfdir.setText("\fBNg");

        textConfdir = new Text(top, SWT.BORDER);
        textConfdir.setText("conf" + BlancoPdfConstants.TARGET_SUBDIRECTORY);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelMetadirComment = new Label(top, SWT.NONE);
        labelMetadirComment.setText("^fBNg͒ʏύXɗp܂B");
        labelMetadirComment.setSize(new org.eclipse.swt.graphics.Point(500,
                30 + 20));

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteGenerateCheckPdf = new Button(top, SWT.NONE);
        buttonExecuteGenerateCheckPdf.setText("y[WmFp PDF ̐");
        buttonExecuteGenerateCheckPdf
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    textConfdir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "PDF eXg", "^fBNg ("
                                                + textConfdir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteGenerateCheckPdf.setEnabled(false);

                            String confDir = textConfdir.getText();
                            if (confDir.trim().length() == 0) {
                                confDir = null;
                            }

                            BlancoPdfGenerateAction
                                    .processBlancoGenerateTestPdf(input
                                            .getFile(), top.getShell(),
                                            getProgressMonitor(), confDir);

                            // tmptH_𓯊
                            BlancoPdfPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // tH_𓯊
                            // ܂łیƂē܂B
                            BlancoPdfPluginUtil
                                    .refreshFolder(input.getFile(),
                                            getProgressMonitor(), textConfdir
                                                    .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteGenerateCheckPdf.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteJavaSource = new Button(top, SWT.NONE);
        buttonExecuteJavaSource.setText("\[XR[h");
        buttonExecuteJavaSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    textConfdir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "^fBNg ("
                                                + textConfdir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJavaSource.setEnabled(false);

                            String runtimePackage = comboRuntimePackage
                                    .getText();
                            if (runtimePackage.trim().length() == 0) {
                                runtimePackage = null;
                            }

                            String confDir = textConfdir.getText();
                            if (confDir.trim().length() == 0) {
                                confDir = null;
                            }

                            BlancoPdfGenerateAction.processBlancoPdfSource(
                                    input.getFile(), top.getShell(),
                                    getProgressMonitor(), runtimePackage,
                                    confDir);

                            // blancotH_𓯊
                            BlancoPdfPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoPdfPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // tH_𓯊
                            // ܂łیƂē܂B
                            BlancoPdfPluginUtil
                                    .refreshFolder(input.getFile(),
                                            getProgressMonitor(), textConfdir
                                                    .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJavaSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelSettingComment = new Label(top, SWT.NONE);
        labelSettingComment.setText("eX̐ݒl "
                + BlancoPdfPluginConstants.TARGET_FILENAME + "t@CɕŊi[܂B");
        labelSettingComment
                .setSize(new org.eclipse.swt.graphics.Point(500, 20));

        loadFromTextEditor();

        setFocusLostHandler(comboRuntimePackage);
        setFocusLostHandler(textConfdir);
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (textConfdir.getText().length() == 0) {
            textConfdir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            textConfdir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    /**
     * ^CpbP[WR{܂B
     * 
     */
    private void createComboRuntimePackage() {
        comboRuntimePackage = new Combo(top, SWT.NONE);
        comboRuntimePackage.add("myapp.jsf");
    }

    protected void loadFromTextEditorInternal(DOMResult argResult) {
        final Node nodeRoot = argResult.getNode();
        if (nodeRoot == null) {
            return;
        }
        final Element elementBlancoPdf = BlancoXmlUtil.getElement(nodeRoot,
                "blanco/target/" + BlancoPdfConstants.PRODUCT_NAME_LOWER);
        if (elementBlancoPdf == null) {
            return;
        }

        final String runtimePackage = elementBlancoPdf
                .getAttribute("runtimepackage");
        if (runtimePackage != null) {
            comboRuntimePackage.setText(runtimePackage);
        }
        final String metadir = elementBlancoPdf.getAttribute("metadir");
        if (metadir != null) {
            textConfdir.setText(metadir);
        }

    }

    /**
     * ۑs܂B
     */
    public Document saveToTextEditorInternal() {
        String runtimepackage = null;
        if (comboRuntimePackage.getText().trim().length() > 0) {
            runtimepackage = comboRuntimePackage.getText();
        }

        String metadir = null;
        if (textConfdir.getText().trim().length() > 0) {
            metadir = textConfdir.getText();
        }

        final Document document = BlancoXmlUtil.newDocument();
        final Element eleBlanco = document.createElement("blanco");
        document.appendChild(eleBlanco);

        final Element eleTarget = document.createElement("target");
        eleTarget.setAttribute("name", textBlancoSettingId.getText());
        eleBlanco.appendChild(eleTarget);

        final Element eleBlancoMessage = document
                .createElement(BlancoPdfConstants.PRODUCT_NAME_LOWER);
        eleTarget.appendChild(eleBlancoMessage);

        if (runtimepackage != null) {
            eleBlancoMessage.setAttribute("runtimepackage", runtimepackage);
        }

        if (metadir != null) {
            eleBlancoMessage.setAttribute("metadir", metadir);
        }

        return document;
    }
}