/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

package blanco.pdf.page.task;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import blanco.pdf.BlancoPdfConstants;
import blanco.pdf.page.BlancoPdfPageUtil;
import blanco.pdf.page.BlancoPdfPageWriter;
import blanco.pdf.page.task.valueobject.BlancoPdfPageDefCheckerProcessInput;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.valueobject.BlancoPdfSetting;

public class BlancoPdfPageDefCheckerProcessImpl implements
        BlancoPdfPageDefCheckerProcess {

    /**
     * {@inheritDoc}
     */
    public int execute(final BlancoPdfPageDefCheckerProcessInput input)
            throws IOException, IllegalArgumentException {
        final File dirPdf = new File(input.getTmpdir() + "/pdf");
        dirPdf.mkdirs();

        final File pageDir = new File(input.getConfdir() + "/page");
        for (File look : pageDir.listFiles()) {
            if (look == null) {
                continue;
            }
            if (look.isDirectory()) {
                continue;
            }

            if (look.getName().endsWith(BlancoPdfConstants.FILEEXT_PDFPAGEDEF) == false) {
                continue;
            }

            final String pageName = look.getName().substring(
                    0,
                    look.getName().length()
                            - BlancoPdfConstants.FILEEXT_PDFPAGEDEF.length());
            if (input.getVerbose()) {
                progress("pageName: " + pageName);
            }

            BlancoPdfPageDef pageDef = null;
            {
                // TODO }`tH[ΉB
                final BlancoPdfSetting setting = new BlancoPdfSetting();
                setting.setConfPath(input.getConfdir());
                pageDef = BlancoPdfPageUtil.read(setting, pageName);
            }

            final OutputStream outStream = new BufferedOutputStream(
                    new FileOutputStream(dirPdf.getAbsolutePath() + "/"
                            + pageDef.getName() + ".pdf"));
            final BlancoPdfPageWriter report = new BlancoPdfPageWriter(input
                    .getConfdir(), pageDef, outStream);
            report.setStrictLocation(input.getStrictlocation());

            report.drawGridSheet();
            report.drawGridSheetItem();

            report.close();
            outStream.close();
        }

        return 0;
    }

    /**
     * {@inheritDoc}
     */
    public boolean progress(final String argProgressMessage) {
        System.out.println(argProgressMessage);
        return false;
    }
}
