/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.csv.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import blanco.csv.BlancoCsvConstants;
import blanco.csv.resourcebundle.BlancoCsvResourceBundle;

/**
 * vOCEBU[h̃y[W̃NXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoCsvWizardPage3 extends WizardPage {
    private static final BlancoCsvResourceBundle fBundle = new BlancoCsvResourceBundle();

    public BlancoCsvWizardPage3(ISelection selection) {
        super("wizardPage");
        setTitle(BlancoCsvConstants.PRODUCT_NAME + "vOC̃CXg[");
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;

        Composite container = new Composite(parent, SWT.NULL);
        container.setLayout(gridLayout);

        new Label(container, SWT.NONE).setText(BlancoCsvConstants.PRODUCT_NAME
                + "vOC𓮍삳邽߂ɂ́AL̂̂KvłB");
        new Label(container, SWT.NONE)
                .setText("  1.Eclipse 3.0܂͂ȏ̃o[WEclipseB");
        new Label(container, SWT.NONE)
                .setText("  2.Excel(*.xls)t@C`ǂݏ\ȃAvP[V\tgB");
        new Label(container, SWT.NONE).setText("    "
                + fBundle.getMetafileDisplayname()
                + " Excel(*.xls)t@C`ŕۑ܂B");
        new Label(container, SWT.NONE)
                .setText("    ̂ Excel(*.xls)t@C`ǂݏ\ȃAvP[V\tgKvɂȂ܂B");

        setControl(container);
    }
}