/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.report.task;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.pdf.page.valueobject.BlancoPdfBlockDef;
import blanco.pdf.page.valueobject.BlancoPdfItemDef;
import blanco.pdf.page.valueobject.BlancoPdfKeyBreakDef;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;

class BlancoPdfReportGenerateOmitDitto {
    void omitDitto(final BlancoPdfPageDef pageDef,
            final BlancoCgObjectFactory cgFactory,
            final BlancoCgSourceFile cgSourceFile, final BlancoCgClass cgClass) {
        final BlancoCgMethod method = cgFactory.createMethod("omitDitto",
                "㍀ڂ̏ȗ{B");
        cgClass.getMethodList().add(method);
        method.getParameterList().add(
                cgFactory.createParameter("itemsList", "java.util.List<"
                        + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReportItems>", "ȗڌQB"));

        if (pageDef.getBlockList().size() == 0) {
            return;
        }
        // TODO ubN 1 ɂΉĂ܂B
        final BlancoPdfBlockDef blockDef = pageDef.getBlockList().get(0);

        method.getLineList().add(
                "for (" + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReportItems items : itemsList) {");

        if (BlancoPdfReportGenerateValueObject.hasLayer(blockDef.getItemList())) {
            method.getLineList().add("int prevLayer = 0;");
        }

        for (BlancoPdfItemDef itemDef : blockDef.getItemList()) {
            if (itemDef.getKey() == false) {
                continue;
            }
            String type = null;
            if ("string".equals(itemDef.getType())) {
                type = "String";
            } else if ("decimal".equals(itemDef.getType())) {
                type = "BigDecimal";
            } else {
                throw new IllegalArgumentException("sȌ^[" + itemDef.getType()
                        + "]^܂B");
            }
            method.getLineList().add(
                    type + " prev"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " = null;");
        }

        method.getLineList().add(
                "for (int index = 0; index < items.get"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "List().size(); index++) {");
        method.getLineList().add(
                "final " + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReport"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "Items next = items.get"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "List().get(index);");

        if (BlancoPdfReportGenerateValueObject.hasLayer(blockDef.getItemList())) {
            method.getLineList().add("if (prevLayer != next.getLayer()) {");
            for (BlancoPdfItemDef itemDef : blockDef.getItemList()) {
                if (itemDef.getKey() == false) {
                    continue;
                }
                method.getLineList().add(
                        "prev"
                                + BlancoNameAdjuster.toClassName(itemDef
                                        .getName()) + " = null;");
            }
            method.getLineList().add("continue;");
            method.getLineList().add("}");
        }

        for (BlancoPdfItemDef itemDef : blockDef.getItemList()) {
            if (itemDef.getKey() == false) {
                continue;
            }
            method.getLineList().add(
                    "if (prev"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " == null || next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "() == null) {");
            method.getLineList().add(
                    "if (prev"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " == next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "()) {");
            method.getLineList().add("// L[ڂv܂B");
            method.getLineList().add(
                    "next.set"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "(null);");
            method.getLineList().add("} else {");
            method.getLineList().add("// L[ڂv܂łB");
            method.getLineList().add(
                    "prev" + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " = next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "();");
            for (BlancoPdfItemDef itemOtherDef : blockDef.getItemList()) {
                // ȉ̃x̃L[ɂāAOLNAB
                if (itemOtherDef.getKey() == false) {
                    continue;
                }
                if (itemOtherDef.getKeyLevel() < itemDef.getKeyLevel()) {
                    continue;
                }
                if (itemOtherDef.getName().equals(itemDef.getName())) {
                    // g̓pXB
                    continue;
                }
                method.getLineList().add(
                        "prev"
                                + BlancoNameAdjuster.toClassName(itemOtherDef
                                        .getName()) + " = null;");
            }

            method.getLineList().add("}");
            method.getLineList().add(
                    "} else if (prev"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + ".compareTo(next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "()) == 0) {");
            method.getLineList().add("// L[ڂv܂B");
            method.getLineList().add(
                    "next.set"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "(null);");
            method.getLineList().add("} else {");
            method.getLineList().add("// L[ڂv܂łB");
            method.getLineList().add(
                    "prev" + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " = next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "();");
            for (BlancoPdfItemDef itemOtherDef : blockDef.getItemList()) {
                // ȉ̃x̃L[ɂāAOLNAB
                if (itemOtherDef.getKey() == false) {
                    continue;
                }
                if (itemOtherDef.getKeyLevel() < itemDef.getKeyLevel()) {
                    continue;
                }
                if (itemOtherDef.getName().equals(itemDef.getName())) {
                    // g̓pXB
                    continue;
                }
                method.getLineList().add(
                        "prev"
                                + BlancoNameAdjuster.toClassName(itemOtherDef
                                        .getName()) + " = null;");
            }
            method.getLineList().add("}");
        }
        method.getLineList().add("}");
        method.getLineList().add("}");
    }

    void dupRowByKey(final BlancoPdfPageDef pageDef,
            final BlancoCgObjectFactory cgFactory,
            final BlancoCgSourceFile cgSourceFile, final BlancoCgClass cgClass) {
        final BlancoCgMethod method = cgFactory.createMethod("dupRowByKey",
                "L[ɍs𕡐B");
        cgClass.getMethodList().add(method);
        method.getParameterList().add(
                cgFactory.createParameter("itemsList", "java.util.List<"
                        + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReportItems>", "ڌQB"));

        if (pageDef.getBlockList().size() == 0) {
            return;
        }
        // TODO ubN 1 ɂΉĂ܂B
        final BlancoPdfBlockDef blockDef = pageDef.getBlockList().get(0);

        method.getLineList().add(
                "for (" + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReportItems items : itemsList) {");

        if (BlancoPdfReportGenerateValueObject.hasLayer(blockDef.getItemList())) {
            method.getLineList().add("int prevLayer = 0;");
        }

        method.getLineList().add(
                BlancoNameAdjuster.toClassName(pageDef.getName()) + "PdfReport"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "Items prev = null;");

        for (BlancoPdfItemDef itemDef : blockDef.getItemList()) {
            if (itemDef.getKey() == false) {
                continue;
            }
            String type = null;
            if ("string".equals(itemDef.getType())) {
                type = "String";
            } else if ("decimal".equals(itemDef.getType())) {
                type = "BigDecimal";
            } else {
                throw new IllegalArgumentException("sȌ^[" + itemDef.getType()
                        + "]^܂B");
            }
            method.getLineList().add(
                    type + " prev"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " = null;");
        }

        method.getLineList().add(
                "for (int index = 0; index < items.get"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "List().size(); index++) {");
        method.getLineList().add(
                "final " + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReport"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "Items next = items.get"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "List().get(index);");

        if (BlancoPdfReportGenerateValueObject.hasLayer(blockDef.getItemList())) {
            method.getLineList().add("if (prevLayer != next.getLayer()) {");
            for (BlancoPdfItemDef itemDef : blockDef.getItemList()) {
                if (itemDef.getKey() == false) {
                    continue;
                }
                method.getLineList().add(
                        "prev"
                                + BlancoNameAdjuster.toClassName(itemDef
                                        .getName()) + " = null;");
            }
            method.getLineList().add("prev = next;");
            method.getLineList().add("continue;");
            method.getLineList().add("}");
        }

        for (BlancoPdfItemDef itemDef : blockDef.getItemList()) {
            if (itemDef.getKey() == false) {
                continue;
            }
            method.getLineList().add(
                    "if (prev"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " == null || next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "() == null) {");
            method.getLineList().add(
                    "if (prev"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " == next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "()) {");
            method.getLineList().add("// L[ڂv܂B");
            method.getLineList().add("} else {");
            method.getLineList().add("// L[ڂv܂łB");
            method.getLineList().add(
                    "prev" + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " = next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "();");
            for (BlancoPdfItemDef itemOtherDef : blockDef.getItemList()) {
                // ȉ̃x̃L[ɂāAOLNAB
                if (itemOtherDef.getKey() == false) {
                    continue;
                }
                if (itemOtherDef.getKeyLevel() < itemDef.getKeyLevel()) {
                    continue;
                }
                if (itemOtherDef.getName().equals(itemDef.getName())) {
                    // g̓pXB
                    continue;
                }
                method.getLineList().add(
                        "prev"
                                + BlancoNameAdjuster.toClassName(itemOtherDef
                                        .getName()) + " = null;");
            }
            method.getLineList().add("// ɕB");
            for (BlancoPdfKeyBreakDef breakDef : itemDef.getKeyBreakAfterList()) {
                method.getLineList().add("if (prev != null) {");
                method.getLineList().add(
                        "final "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "Items add = new "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName()) + "Items();");
                method.getLineList().add(
                        "items.get"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "List().add(index++, add);");
                method.getLineList().add(
                        "add.setLayer(" + breakDef.getDupLayerTarget() + ");");
                for (BlancoPdfItemDef copyItem : blockDef.getItemList()) {
                    method.getLineList().add(
                            "add.set"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName())
                                    + "(prev.get"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName()) + "());");
                }
                method.getLineList().add("}");
            }
            for (BlancoPdfKeyBreakDef breakDef : itemDef
                    .getKeyBreakBeforeList()) {
                method.getLineList().add("{");
                method.getLineList().add(
                        "final "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "Items add = new "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName()) + "Items();");
                method.getLineList().add(
                        "items.get"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "List().add(index++, add);");
                method.getLineList().add(
                        "add.setLayer(" + breakDef.getDupLayerTarget() + ");");
                for (BlancoPdfItemDef copyItem : blockDef.getItemList()) {
                    method.getLineList().add(
                            "add.set"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName())
                                    + "(next.get"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName()) + "());");
                }
                method.getLineList().add("}");
            }

            method.getLineList().add("}");
            method.getLineList().add(
                    "} else if (prev"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + ".compareTo(next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "()) == 0) {");
            method.getLineList().add("// L[ڂv܂B");
            method.getLineList().add("} else {");
            method.getLineList().add("// L[ڂv܂łB");
            method.getLineList().add(
                    "prev" + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + " = next.get"
                            + BlancoNameAdjuster.toClassName(itemDef.getName())
                            + "();");
            for (BlancoPdfItemDef itemOtherDef : blockDef.getItemList()) {
                // ȉ̃x̃L[ɂāAOLNAB
                if (itemOtherDef.getKey() == false) {
                    continue;
                }
                if (itemOtherDef.getKeyLevel() < itemDef.getKeyLevel()) {
                    continue;
                }
                if (itemOtherDef.getName().equals(itemDef.getName())) {
                    // g̓pXB
                    continue;
                }
                method.getLineList().add(
                        "prev"
                                + BlancoNameAdjuster.toClassName(itemOtherDef
                                        .getName()) + " = null;");
            }
            method.getLineList().add("// ɕB");
            for (BlancoPdfKeyBreakDef breakDef : itemDef.getKeyBreakAfterList()) {
                method.getLineList().add("if (prev != null) {");
                method.getLineList().add(
                        "final "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "Items add = new "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName()) + "Items();");
                method.getLineList().add(
                        "items.get"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "List().add(index++, add);");
                method.getLineList().add(
                        "add.setLayer(" + breakDef.getDupLayerTarget() + ");");
                for (BlancoPdfItemDef copyItem : blockDef.getItemList()) {
                    method.getLineList().add(
                            "add.set"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName())
                                    + "(prev.get"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName()) + "());");
                }
                method.getLineList().add("}");
            }
            for (BlancoPdfKeyBreakDef breakDef : itemDef
                    .getKeyBreakBeforeList()) {
                method.getLineList().add("{");
                method.getLineList().add(
                        "final "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "Items add = new "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName()) + "Items();");
                method.getLineList().add(
                        "items.get"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "List().add(index++, add);");
                method.getLineList().add(
                        "add.setLayer(" + breakDef.getDupLayerTarget() + ");");
                for (BlancoPdfItemDef copyItem : blockDef.getItemList()) {
                    method.getLineList().add(
                            "add.set"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName())
                                    + "(next.get"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName()) + "());");
                }
                method.getLineList().add("}");
            }

            method.getLineList().add("}");
        }
        method.getLineList().add("prev = next;");
        method.getLineList().add("}");

        for (BlancoPdfItemDef itemDef : blockDef.getItemList()) {
            if (itemDef.getKey() == false) {
                continue;
            }
            // Ō̈ꔭB
            for (BlancoPdfKeyBreakDef breakDef : itemDef.getKeyBreakAfterList()) {
                method.getLineList().add("if (prev != null) {");
                method.getLineList().add(
                        "final "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName())
                                + "Items add = new "
                                + BlancoNameAdjuster.toClassName(pageDef
                                        .getName())
                                + "PdfReport"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName()) + "Items();");
                // Ōɑ}B
                method.getLineList().add(
                        "items.get"
                                + BlancoNameAdjuster.toClassName(blockDef
                                        .getName()) + "List().add(add);");
                method.getLineList().add(
                        "add.setLayer(" + breakDef.getDupLayerTarget() + ");");
                for (BlancoPdfItemDef copyItem : blockDef.getItemList()) {
                    method.getLineList().add(
                            "add.set"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName())
                                    + "(prev.get"
                                    + BlancoNameAdjuster.toClassName(copyItem
                                            .getName()) + "());");
                }
                method.getLineList().add("}");
            }
        }

        method.getLineList().add("}");
    }
}
