/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.db.common.stringgroup.BlancoDbSqlInfoTypeStringGroup;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.jsf.db.BlancoJsfDbParser;
import blanco.jsf.message.BlancoJsfMessage;
import blanco.jsf.task.valueobject.BlancoJsfProcessInput;
import blanco.jsf.valueobject.BlancoJsfProcessSqlItemStructure;
import blanco.jsf.valueobject.BlancoJsfProcessStructure;
import blanco.jsf.valueobject.BlancoJsfStructure;

/**
 * uob``vExcellob`钊ېeNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoJsfXml2SourceFile {
    /**
     * bZ[WNXB
     */
    protected final BlancoJsfMessage fMsg = new BlancoJsfMessage();

    /**
     * XMLt@Cp[X܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public List<BlancoJsfStructure> parse(final File argMetaXmlSourceFile,
            final BlancoJsfProcessInput input) throws IOException {
        return new BlancoJsfXmlParser().parse(argMetaXmlSourceFile);
    }

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final BlancoJsfProcessInput input) throws IOException {
        final List<BlancoDbSqlInfoStructure> sqlInfoList = new BlancoJsfDbParser()
                .process(input);

        // ^̉͌ʂƂɃ\[XR[hs܂B
        structure2Source(structure, listJsfStructure, sqlInfoList, input);
    }

    /**
     * ^ꂽNXo[IuWFNgAJava\[XR[h܂B
     * 
     * @param structure
     *            B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    public void structure2Source(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final List<BlancoDbSqlInfoStructure> sqlInfoList,
            final BlancoJsfProcessInput input) throws IOException {
        for (BlancoJsfProcessStructure processStructure : structure
                .getProcessList()) {
            final List<String> sqlClassNameList = getSqlClassNameList(
                    processStructure, sqlInfoList);

            final BlancoJsfExpandLogic expandLogic = new BlancoJsfExpandLogic();
            expandLogic.expandSourceFile(structure, listJsfStructure,
                    processStructure, sqlClassNameList, input);
        }

        final BlancoJsfExpandLogicProxy expandLogicProxy = new BlancoJsfExpandLogicProxy();
        expandLogicProxy.expandSourceFile(structure, listJsfStructure,
                sqlInfoList, input);

        final BlancoJsfExpandException expandException = new BlancoJsfExpandException();
        expandException.expandSourceFile(structure, listJsfStructure,
                sqlInfoList, input);

        final BlancoJsfExpandDownloadInfo expandDownloadInfo = new BlancoJsfExpandDownloadInfo();
        expandDownloadInfo.expandSourceFile(structure, listJsfStructure, input);
    }

    public List<String> getSqlClassNameList(
            final BlancoJsfProcessStructure processStructure,
            final List<BlancoDbSqlInfoStructure> sqlInfoList) {
        final List<String> result = new ArrayList<String>();
        for (BlancoJsfProcessSqlItemStructure sqlItem : processStructure
                .getSqlList()) {
            boolean isFound = false;
            for (BlancoDbSqlInfoStructure sqlinfo : sqlInfoList) {
                if (sqlItem.getName().equals(sqlinfo.getName())) {
                    String basePackage = BlancoStringUtil.null2Blank(sqlinfo
                            .getPackage());
                    if (basePackage.length() == 0) {
                        basePackage = "noname";
                    }
                    final String sqlClassName = basePackage
                            + ".query."
                            + BlancoNameAdjuster.toClassName(sqlItem.getName())
                            + BlancoNameAdjuster
                                    .toUpperCaseTitle(new BlancoDbSqlInfoTypeStringGroup()
                                            .convertToString(sqlinfo.getType()));
                    result.add(sqlClassName);
                    isFound = true;
                    break;
                }
            }
            if (isFound == false) {
                throw new IllegalArgumentException(fMsg.getMbjfg001(
                        processStructure.getName(), processStructure
                                .getMethod(), sqlItem.getName()));
            }
        }

        return result;
    }
}
