/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sample.jsf.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.servlet.http.HttpServletResponse;

import blanco.sample.jsf.BlancoJsfSample1AddLogic;
import blanco.sample.jsf.BlancoJsfSample1CompleteLogic;
import blanco.sample.jsf.BlancoJsfSample1DownloadLogic;
import blanco.sample.jsf.BlancoJsfSample1InitializeLogic;
import blanco.sample.jsf.BlancoJsfSample1ModifyLogic;
import blanco.sample.jsf.BlancoJsfSample1ViewLogic;
import blanco.sample.jsf.db.query.SimpleBookInsertInvoker;
import blanco.sample.jsf.db.query.SimpleBookSelectIterator;
import blanco.sample.jsf.util.BlancoJsfDownloadInfo;
import blanco.sample.jsf.util.BlancoJsfLogicException;
import blanco.sample.jsf.util.BlancoJsfProxyUtil;

/**
 * JSF  Managed Bean Ǝۂ̏ƂȂvLVENXB
 *
 * <p>faces-config.xml ɂ͈ȉ̂悤ɓo^܂B</p>
 * <pre>
 * &lt;managed-bean&gt;
 * 	&lt;managed-bean-name&gt;BlancoJsfSample1Logic&lt;/managed-bean-name&gt;
 * 	&lt;managed-bean-class&gt;blanco.sample.jsf.proxy.BlancoJsfSample1LogicProxy&lt;/managed-bean-class&gt;
 * &lt;managed-bean-scope&gt;request&lt;/managed-bean-scope&gt;
 * &lt;/managed-bean&gt;
 * </pre>
 */
@SuppressWarnings("serial")
public class BlancoJsfSample1LogicProxy extends String {
    /**
     * ꂽǂB
     */
    private boolean fIsInitialized = false;

    /**
     * y[W̏ʁB
     */
    private String fOutcome = "error";

    /**
     * ʃ[hB
     *
     * @return eɂ炸A߂܂B
     */
    public String getLoad() {
        if (fIsInitialized == false) {
            initialize(null);
            fIsInitialized = true;
        }
        view(null);

        return "";
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param nullActionEvent CxgB
     */
    public final void initialize(final ActionEvent nullActionEvent) {
        final FacesContext ctx = FacesContext.getCurrentInstance();

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1InitializeLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1InitializeLogic logic = new blanco.sample.jsf.BlancoJsfSample1InitializeLogicImpl();

        // FacesMessage ̃[NB
        final List<FacesMessage> facesMessageList = new ArrayList<FacesMessage>();

        try {
            try {
                logic.execute(this, facesMessageList, ctx);
            } finally {
                // [N FacesMessage ڑB
                for (FacesMessage facesMessage : facesMessageList) {
                    ctx.addMessage(null, facesMessage);
                }
            }
        } catch (BlancoJsfLogicException ex) {
            // WbNOB
        } catch (IllegalArgumentException ex) {
            BlancoJsfProxyUtil.logIllegalArgumentException("O: blanco.sample.jsf.BlancoJsfSample1InitializeLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (IOException ex) {
            BlancoJsfProxyUtil.logIOException("o͗O: blanco.sample.jsf.BlancoJsfSample1InitializeLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Exception ex) {
            BlancoJsfProxyUtil.logException("O: blanco.sample.jsf.BlancoJsfSample1InitializeLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Error er) {
            BlancoJsfProxyUtil.logError("G[: blanco.sample.jsf.BlancoJsfSample1InitializeLogicImpl", er);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        }
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param nullActionEvent CxgB
     */
    public final void view(final ActionEvent nullActionEvent) {
        final FacesContext ctx = FacesContext.getCurrentInstance();

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1ViewLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1ViewLogic logic = new blanco.sample.jsf.BlancoJsfSample1ViewLogicImpl();

        // FacesMessage ̃[NB
        final List<FacesMessage> facesMessageList = new ArrayList<FacesMessage>();

        try {
            try {
                logic.execute(this, facesMessageList, ctx);
            } finally {
                // [N FacesMessage ڑB
                for (FacesMessage facesMessage : facesMessageList) {
                    ctx.addMessage(null, facesMessage);
                }
            }
        } catch (BlancoJsfLogicException ex) {
            // WbNOB
        } catch (IllegalArgumentException ex) {
            BlancoJsfProxyUtil.logIllegalArgumentException("O: blanco.sample.jsf.BlancoJsfSample1ViewLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (IOException ex) {
            BlancoJsfProxyUtil.logIOException("o͗O: blanco.sample.jsf.BlancoJsfSample1ViewLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Exception ex) {
            BlancoJsfProxyUtil.logException("O: blanco.sample.jsf.BlancoJsfSample1ViewLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Error er) {
            BlancoJsfProxyUtil.logError("G[: blanco.sample.jsf.BlancoJsfSample1ViewLogicImpl", er);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        }
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param actionEvent CxgB
     */
    public final void add(final ActionEvent actionEvent) {
        final FacesContext ctx = FacesContext.getCurrentInstance();
        final ELContext elc = ctx.getELContext();
        final ELResolver rslvr = ctx.getApplication().getELResolver();

        // session  Managed Bean [integer] 擾܂B
        final Integer argInteger = (Integer) rslvr.getValue(elc, null, "integer");
        // session  Managed Bean [blancoJsfSample2Logic] 擾܂B
        final String argString = (String) rslvr.getValue(elc, null, "blancoJsfSample2Logic");

        final Connection conn = BlancoJsfProxyUtil.getConnection();
        boolean isLogicSuccess = false;
        final SimpleBookSelectIterator argSimpleBookSelectIterator = new SimpleBookSelectIterator(conn);
        final SimpleBookInsertInvoker argSimpleBookInsertInvoker = new SimpleBookInsertInvoker(conn);

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1AddLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1AddLogic logic = new blanco.sample.jsf.BlancoJsfSample1AddLogicImpl();

        // FacesMessage ̃[NB
        final List<FacesMessage> facesMessageList = new ArrayList<FacesMessage>();

        try {
            fOutcome = "error";
            try {
                final String outcome = logic.execute(this, argInteger, argString, argSimpleBookSelectIterator, argSimpleBookInsertInvoker, conn, facesMessageList, ctx);

                conn.commit();
                isLogicSuccess = true;
                fOutcome = outcome;
            } finally {
                // [N FacesMessage ڑB
                for (FacesMessage facesMessage : facesMessageList) {
                    ctx.addMessage(actionEvent.getComponent().getClientId(ctx), facesMessage);
                }
                argSimpleBookSelectIterator.close();
                argSimpleBookInsertInvoker.close();
            }
        } catch (BlancoJsfLogicException ex) {
            // WbNOB
            fOutcome = "fail";
        } catch (IllegalArgumentException ex) {
            BlancoJsfProxyUtil.logIllegalArgumentException("O: blanco.sample.jsf.BlancoJsfSample1AddLogicImpl", ex);
        } catch (IOException ex) {
            BlancoJsfProxyUtil.logIOException("o͗O: blanco.sample.jsf.BlancoJsfSample1AddLogicImpl", ex);
        } catch (SQLException ex) {
            BlancoJsfProxyUtil.logSQLException("SQLO: blanco.sample.jsf.BlancoJsfSample1AddLogicImpl", ex);
        } catch (Exception ex) {
            BlancoJsfProxyUtil.logException("O: blanco.sample.jsf.BlancoJsfSample1AddLogicImpl", ex);
        } catch (Error er) {
            BlancoJsfProxyUtil.logError("G[: blanco.sample.jsf.BlancoJsfSample1AddLogicImpl", er);
        }

        if (isLogicSuccess == false) {
            try {
                conn.rollback();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        // RlNV̊JB
        BlancoJsfProxyUtil.releaseConnection(conn);
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param actionEvent CxgB
     */
    public final void modify(final ActionEvent actionEvent) {
        final FacesContext ctx = FacesContext.getCurrentInstance();
        final ELContext elc = ctx.getELContext();
        final ELResolver rslvr = ctx.getApplication().getELResolver();

        // session  Managed Bean [bigDecimal] 擾܂B
        final BigDecimal argBigDecimal = (BigDecimal) rslvr.getValue(elc, null, "bigDecimal");
        // session  Managed Bean [integer] 擾܂B
        final Integer argInteger = (Integer) rslvr.getValue(elc, null, "integer");

        final Connection conn = BlancoJsfProxyUtil.getConnection();
        boolean isLogicSuccess = false;
        final SimpleBookSelectIterator argSimpleBookSelectIterator = new SimpleBookSelectIterator(conn);

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1ModifyLogic logic = new blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl();

        try {
            try {
                logic.execute(this, argBigDecimal, argInteger, argSimpleBookSelectIterator, conn, actionEvent);

                conn.commit();
                isLogicSuccess = true;
            } finally {
                argSimpleBookSelectIterator.close();
            }
        } catch (BlancoJsfLogicException ex) {
            // WbNOB
        } catch (IllegalArgumentException ex) {
            BlancoJsfProxyUtil.logIllegalArgumentException("O: blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (IOException ex) {
            BlancoJsfProxyUtil.logIOException("o͗O: blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (SQLException ex) {
            BlancoJsfProxyUtil.logSQLException("SQLO: blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Exception ex) {
            BlancoJsfProxyUtil.logException("O: blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Error er) {
            BlancoJsfProxyUtil.logError("G[: blanco.sample.jsf.BlancoJsfSample1ModifyLogicImpl", er);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        }

        if (isLogicSuccess == false) {
            try {
                conn.rollback();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        // RlNV̊JB
        BlancoJsfProxyUtil.releaseConnection(conn);
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param actionEvent CxgB
     */
    public final void download(final ActionEvent actionEvent) {
        final FacesContext ctx = FacesContext.getCurrentInstance();

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        final BlancoJsfDownloadInfo downloadInfo = new BlancoJsfDownloadInfo();
        downloadInfo.setContentType("application/octet-stream");

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1DownloadLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1DownloadLogic logic = new blanco.sample.jsf.BlancoJsfSample1DownloadLogicImpl();

        try {
            try {
                logic.execute(this, downloadInfo, outStream);
                outStream.flush();
                outStream.close();
            } finally {
            }
        } catch (BlancoJsfLogicException ex) {
            // WbNOB
        } catch (IllegalArgumentException ex) {
            BlancoJsfProxyUtil.logIllegalArgumentException("O: blanco.sample.jsf.BlancoJsfSample1DownloadLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (IOException ex) {
            BlancoJsfProxyUtil.logIOException("o͗O: blanco.sample.jsf.BlancoJsfSample1DownloadLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Exception ex) {
            BlancoJsfProxyUtil.logException("O: blanco.sample.jsf.BlancoJsfSample1DownloadLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Error er) {
            BlancoJsfProxyUtil.logError("G[: blanco.sample.jsf.BlancoJsfSample1DownloadLogicImpl", er);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        }
        try {
            // ۂ̃_E[hB_E[h̐EśÃ\bhł͕ۏ؂ȂB
            sendBinaryResponse(outStream.toByteArray(), downloadInfo);
        } catch (IOException ex) {
            BlancoJsfProxyUtil.logIOException("o͗O: _E[h: blanco.sample.jsf.BlancoJsfSample1DownloadLogicImpl", ex);
        }
    }

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param argPfAutoCompleteInput NGXgEXgOB
     * @return X|XEXgOEXgB
     */
    public final List<java.lang.String> complete(final String argPfAutoCompleteInput) {
        final List<java.lang.String> pfAutoCompleteResult = new ArrayList<java.lang.String>();
        final FacesContext ctx = FacesContext.getCurrentInstance();

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1CompleteLogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1CompleteLogic logic = new blanco.sample.jsf.BlancoJsfSample1CompleteLogicImpl();

        try {
            try {
                logic.execute(this, argPfAutoCompleteInput, pfAutoCompleteResult);
            } finally {
            }
        } catch (BlancoJsfLogicException ex) {
            // WbNOB
        } catch (IllegalArgumentException ex) {
            BlancoJsfProxyUtil.logIllegalArgumentException("O: blanco.sample.jsf.BlancoJsfSample1CompleteLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (IOException ex) {
            BlancoJsfProxyUtil.logIOException("o͗O: blanco.sample.jsf.BlancoJsfSample1CompleteLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Exception ex) {
            BlancoJsfProxyUtil.logException("O: blanco.sample.jsf.BlancoJsfSample1CompleteLogicImpl", ex);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        } catch (Error er) {
            BlancoJsfProxyUtil.logError("G[: blanco.sample.jsf.BlancoJsfSample1CompleteLogicImpl", er);
            BlancoJsfProxyUtil.redirectPageToErrorHtml(ctx);
        }
        return pfAutoCompleteResult;
    }

    /**
     * sʂ擾B
     *
     * @return ʏB
     */
    public final String outcome() {
        return fOutcome;
    }

    /**
     * _E[hB
     *
     * @param bufBinary _E[hEf[^B
     * @param downloadInfo _E[hB
     * @throws IOException o͗OꍇB
     */
    public void sendBinaryResponse(final byte[] bufBinary, final BlancoJsfDownloadInfo downloadInfo) throws IOException {
        final FacesContext context = FacesContext.getCurrentInstance();
        final HttpServletResponse response = (HttpServletResponse) context.getExternalContext().getResponse();
        response.setContentType(downloadInfo.getContentType());
        if (downloadInfo.getAttachment()) {
            response.setHeader("Content-Disposition", "attachment; filename=" + downloadInfo.getFilename());
        }

        // RecX|XɃRs[B
        final InputStream inStream = new BufferedInputStream(new ByteArrayInputStream(bufBinary));
        final OutputStream outStream = new BufferedOutputStream(response.getOutputStream());
        final byte[] buf = new byte[8192];
        for (;;) {
            int length = inStream.read(buf);
            if (length <= 0) {
                break;
            }
            outStream.write(buf, 0, length);
        }
        outStream.flush();
        if (response.isCommitted()) {
            try {
                outStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        // |Cg!!@㑱̏(_O)~߂܂B
        context.responseComplete();
    }
}
