/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sample.jsf.util;

/**
 * _E[hNXB
 */
public class BlancoJsfDownloadInfo {
    /**
     * tB[h: [ContentType]B
     * ftHg: [application/octet-stream]B
     */
    private String fContentType = "application/octet-stream";

    /**
     * tB[h: [filename]B
     */
    private String fFilename;

    /**
     * tB[h: [attachment]B
     * ftHg: [false]B
     */
    private boolean fAttachment = false;

    /**
     * tB[h [ContentType] ̒lݒ肵܂B
     *
     * @param argContentType tB[h[ContentType]ɐݒ肷lB
     */
    public void setContentType(final String argContentType) {
        fContentType = argContentType;
    }

    /**
     * tB[h [ContentType] ̒l擾܂B
     *
     * ftHg: [application/octet-stream]B
     *
     * @return tB[h[ContentType]擾lB
     */
    public String getContentType() {
        return fContentType;
    }

    /**
     * tB[h [filename] ̒lݒ肵܂B
     *
     * @param argFilename tB[h[filename]ɐݒ肷lB
     */
    public void setFilename(final String argFilename) {
        fFilename = argFilename;
    }

    /**
     * tB[h [filename] ̒l擾܂B
     *
     * @return tB[h[filename]擾lB
     */
    public String getFilename() {
        return fFilename;
    }

    /**
     * tB[h [attachment] ̒lݒ肵܂B
     *
     * @param argAttachment tB[h[attachment]ɐݒ肷lB
     */
    public void setAttachment(final boolean argAttachment) {
        fAttachment = argAttachment;
    }

    /**
     * tB[h [attachment] ̒l擾܂B
     *
     * ftHg: [false]B
     *
     * @return tB[h[attachment]擾lB
     */
    public boolean getAttachment() {
        return fAttachment;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.sample.jsf.util.BlancoJsfDownloadInfo[");
        buf.append("ContentType=" + fContentType);
        buf.append(",filename=" + fFilename);
        buf.append(",attachment=" + fAttachment);
        buf.append("]");
        return buf.toString();
    }
}
