/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.log.logging;

import java.util.logging.LogRecord;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import blanco.log.BlancoLogConstants;

/**
 * java.util.logging ̏o͂ Apache log4j Ƀ_CNg邽߂̃nhNX̓B
 * 
 * @author IGA Tosiki
 */
class BlancoLogLog4jHandlerInternal {
    /**
     * {܂B
     * 
     * ۂɂ́A Apache log4j ݊mF̂߂Ƀ[gK[擾܂B
     */
    public void init() {
        // Apache log4j ݊mF̂߂Ƀ[gK[擾܂B
        final Logger logger = Logger.getRootLogger();

        logger.trace("BlancoLogLog4jHandler(" + BlancoLogConstants.VERSION
                + "): start redirecting: java.util.logging -> Apache log4j");
    }

    /**
     * ^ꂽOR[hMO܂B
     * 
     * @param argLogRecord
     *            OR[hB
     */
    public void publish(final LogRecord argLogRecord) {
        String message = argLogRecord.getMessage();
        Level level = null;

        switch (argLogRecord.getLevel().intValue()) {
        case BlancoLogLoggingConstants.FINEST:
        case BlancoLogLoggingConstants.FINER:
            // }bv悪̂ FINEST  FINER ̂ trace Ƀ}bvB
            level = Level.TRACE;
            break;
        case BlancoLogLoggingConstants.FINE:
            // FINE  debug Ƀ}bvB
            level = Level.DEBUG;
            break;
        case BlancoLogLoggingConstants.CONFIG:
            // }bv悪̂ CONFIG  infoɃ}bvB
            level = Level.DEBUG;
            message = "config: " + message;
            break;
        case BlancoLogLoggingConstants.INFO:
            level = Level.INFO;
            break;
        case BlancoLogLoggingConstants.WARNING:
            level = Level.WARN;
            break;
        case BlancoLogLoggingConstants.SEVERE:
            level = Level.ERROR;
            if (argLogRecord.getMessage().length() >= 5) {
                final String head = argLogRecord.getMessage().substring(0, 5);
                if ("fatal".equals(head.toLowerCase())) {
                    // bZ[W fatal ܂ FATAL ŊJnꍇɂ̂ fatal Ƀ}bsOB
                    level = Level.FATAL;
                }
            }
            break;
        default:
            // 傤Ȃ̂infoɃ}bvB
            level = Level.INFO;
            message = "[" + argLogRecord.getLevel().intValue() + "]"
                    + argLogRecord.getMessage();
            break;
        }

        // ̃\bhŃK[擾̂́AargLogRecord.getLoggerName()
        // ^邱Ƃł̂̃^C~OłB
        // ̏RXgN^Ŏ{邱Ƃ͏o܂B
        // tB[hϐƂ Loggerێ邱Ƃł܂B
        final Logger log4jLogger = Logger.getLogger(argLogRecord
                .getLoggerName());

        if (argLogRecord.getThrown() == null) {
            log4jLogger.log(level, message);
        } else {
            log4jLogger.log(level, message, argLogRecord.getThrown());
        }
    }

    /**
     * K[tbV܂B
     */
    public void flush() {
        // ɉ܂B
    }

    /**
     * K[N[Y܂B
     * 
     * @throws SecurityException
     *             ZLeBOꍇB
     */
    public void close() throws SecurityException {
        // ɉ܂B
    }
}
