/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.common;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoBigDecimalUtil;
import blanco.db.common.resourcebundle.BlancoDbCommonResourceBundle;
import blanco.db.common.stringgroup.BlancoDbExecuteSqlStringGroup;
import blanco.db.common.stringgroup.BlancoDbSqlInfoTypeStringGroup;
import blanco.db.common.util.BlancoDbQueryParserUtil;
import blanco.db.common.util.BlancoDbXmlParser;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.dbmetadata.BlancoDbMetaDataSql;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * SQL`̒XMLt@C͂ƂāASQL`Ɋւe\̂\z܂B
 * 
 * ̃NX̒ł́A^SQL͎ۂSQLs܂BSQLs邱ƂɂAʂ̗ꗗ擾A
 * SQL̓p[^̑Ó̃`FbNsA邢SQL sł邩ǂmF邱Ƃł܂B
 * 
 * @author Yasuo Nakanishi
 */
public class BlancoDbXml2SqlInfo {
    /**
     * blancoDb\[Xohւ̃ANZTB
     */
    private final BlancoDbCommonResourceBundle fBundle = new BlancoDbCommonResourceBundle();

    /**
     * SQL`̒XMLt@C͂ƂāASQL`Ɋւe\̂\z܂B
     * 
     * @param conn
     *            f[^x[XڑB
     * @param dbSetting
     *            blancoDbݒB
     * @param fileSqlForm
     *            ͂Ƃ钆XMLt@CB
     * @return SQL`\̃XgB
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws TransformerException
     */
    public List<BlancoDbSqlInfoStructure> process(final Connection conn,
            final BlancoDbSetting dbSetting, final File fileSqlForm)
            throws SQLException, SAXException, IOException,
            ParserConfigurationException, TransformerException {

        final List<BlancoDbSqlInfoStructure> blancoDbDef = new BlancoDbXmlParser()
                .parse(fileSqlForm);

        for (int index = 0; index < blancoDbDef.size(); index++) {
            final BlancoDbSqlInfoStructure sqlInfo = blancoDbDef.get(index);

            if (sqlInfo.getType() == BlancoDbSqlInfoTypeStringGroup.ITERATOR) {
                // Wꂽ̂̂A^ɂẮAf[^x[XڑĎłs܂B
                try {
                    final BlancoDbQueryParserUtil parserUtil = new BlancoDbQueryParserUtil(
                            sqlInfo.getQuery());

                    // SQLsČʃZbg擾A猟ʂ̗ꗗ擾܂B
                    // JDBC̋@\𗘗pSQLłAʂ̗ꗗ擾ƂAblancoDb̊jƂ@\̎ӏłB

                    List<BlancoDbMetaDataColumnStructure> nativeParam = convertSqlInParameter2NativeParameter(
                            sqlInfo, parserUtil);
                    if (dbSetting.getExecuteSql() == BlancoDbExecuteSqlStringGroup.NONE) {
                        // nonȅꍇɂ paramnullZbg܂B
                        nativeParam = null;
                    }

                    // paramɒlZbgĂꍇɂSQLs܂B
                    final List<BlancoDbMetaDataColumnStructure> listResult = BlancoDbMetaDataSql
                            .getResultSetMetaData(conn, parserUtil
                                    .getNaturalSqlStringForJava(), nativeParam);

                    // ʃZbg̗̈ꗗɂāAW̏ƂċL܂B
                    sqlInfo.setResultSetColumnList(listResult);

                } catch (SQLException e) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2javaclassErr002(sqlInfo.getName(), e
                                    .getSQLState(), BlancoBigDecimalUtil
                                    .toBigDecimal(e.getErrorCode()), e
                                    .toString()));
                }
            }
        }

        return blancoDbDef;
    }

    /**
     * SQL`SQL̓p[^AۂJDBCŎsSQLSQL̓p[^ւƕϊ܂B
     * 
     * @param sqlInfo
     * @param parserUtil
     * @return
     */
    private List<BlancoDbMetaDataColumnStructure> convertSqlInParameter2NativeParameter(
            final BlancoDbSqlInfoStructure sqlInfo,
            final BlancoDbQueryParserUtil parserUtil) {
        // ꖼ̂ۂSQL ? ɑΉ邽߂ɕɓWJ܂B
        int maxNativeCol = 0;
        final Map<String, BlancoDbMetaDataColumnStructure> hashCol = new HashMap<String, BlancoDbMetaDataColumnStructure>();

        for (int indexCol = 0; indexCol < sqlInfo.getInParameterList().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = sqlInfo
                    .getInParameterList().get(indexCol);
            final int[] listNativeCol = parserUtil
                    .getSqlParameters(columnStructure.getName());
            if (listNativeCol == null) {
                throw new IllegalArgumentException("SQL`ID["
                        + sqlInfo.getName() + "] SQL̓p[^["
                        + columnStructure.getName() + "]тĂ܂.");
            }

            for (int indexSearch = 0; indexSearch < listNativeCol.length; indexSearch++) {
                maxNativeCol = Math.max(listNativeCol[indexSearch],
                        maxNativeCol);
                hashCol.put(String.valueOf(listNativeCol[indexSearch]),
                        columnStructure);
            }
        }

        final List<BlancoDbMetaDataColumnStructure> nativeParam = new ArrayList<BlancoDbMetaDataColumnStructure>();
        for (int indexNativeCol = 1; indexNativeCol <= maxNativeCol; indexNativeCol++) {
            final BlancoDbMetaDataColumnStructure objLook = hashCol.get(String
                    .valueOf(indexNativeCol));
            if (objLook == null) {
                throw new IllegalArgumentException("SQL`ID["
                        + sqlInfo.getName() + "] SQL̓p[^WJɗ\ʗO. ("
                        + indexNativeCol + ")Ԗڂ̓̓p[^擾ł܂B");
            }
            nativeParam.add(objLook);
        }

        return nativeParam;
    }
}