/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobjectdotnet;

import java.io.File;
import java.io.IOException;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.valueobjectdotnet.resourcebundle.BlancoValueObjectDotNetResourceBundle;
import blanco.valueobjectdotnet.util.BlancoValueObjectDotNetUtil;
import blanco.valueobjectdotnet.valueobject.BlancoValueObjectDotNetClassStructure;
import blanco.valueobjectdotnet.valueobject.BlancoValueObjectDotNetFieldStructure;

/**
 * blancoValueObject̎傽NXB
 * 
 * blancoValueObject\XMLt@C Java\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectDotNetXml2SourceFile {

    /**
     * blancoValueObject̃\[XohIuWFNgB
     */
    private final BlancoValueObjectDotNetResourceBundle bundle = new BlancoValueObjectDotNetResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * tB[h⃁\bh̖Oό`sǂB
     */
    private boolean fNameAdjust = true;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * ValueObject\XMLt@C Java\[XR[h܂B
     * 
     * @param metaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param directoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File metaXmlSourceFile, final File directoryTarget)
            throws IOException {

        final BlancoValueObjectDotNetClassStructure[] structures = new BlancoValueObjectDotNetXmlParser()
                .parse(metaXmlSourceFile);
        for (int index = 0; index < structures.length; index++) {
            // ꂽ񂩂Java\[XR[h𐶐܂B
            structure2Source(structures[index], directoryTarget);
        }
    }

    /**
     * ^ꂽNXƂJava\[XR[h܂B
     * 
     * @param classInfo
     *            NX
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    public void structure2Source(
            final BlancoValueObjectDotNetClassStructure argClassStructure,
            final File argDirectoryTarget) throws IOException {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        // BlancoCgObjectFactoryNX̃CX^X擾܂B
        fCgFactory = BlancoCgObjectFactory.getInstance();

        fCgSourceFile = fCgFactory.createSourceFile(argClassStructure
                .getPackage(), null);
        fCgSourceFile.setEncoding(fEncoding);

        // NX쐬܂B
        fCgClass = fCgFactory.createClass(argClassStructure.getName(), "");
        fCgSourceFile.getClassList().add(fCgClass);

        // NX̃ANZXݒB
        // fCgClass.setAccess(argClassStructure.getAccess());
        // ۃNXǂB
        // fCgClass.setAbstract(argClassStructure.getAbstract());

        // o[IuWFNg͒񉻉\Ő܂B
        fCgClass.getAnnotationList().add("SerializableAttribute");

        // ftHg SystemOԂ͓܂B
        fCgSourceFile.getImportList().add("System.String");

        // t@CRg͔jI

        if (argClassStructure.getDescription() != null) {
            final String[] lines = BlancoValueObjectDotNetUtil
                    .escapeStringAsCsDocWithNewLine(argClassStructure
                            .getDescription());
            for (int index = 0; index < lines.length; index++) {
                fCgClass.getLangDoc().getDescriptionList().add(lines[index]);
            }
        }

        for (String line : argClassStructure.getDescriptionList()) {
            fCgClass.getLangDoc().getDescriptionList().add(line);
        }

        for (int indexField = 0; indexField < argClassStructure.getFieldList()
                .size(); indexField++) {
            final BlancoValueObjectDotNetFieldStructure field = (BlancoValueObjectDotNetFieldStructure) argClassStructure
                    .getFieldList().get(indexField);

            if (field.getName() == null) {
                throw new IllegalArgumentException(bundle
                        .getXml2csclassErr003(argClassStructure.getName()));
            }
            if (field.getType() == null) {
                throw new IllegalArgumentException(bundle.getXml2csclassErr004(
                        argClassStructure.getName(), field.getName()));
            }

            if (field.getType().equals("String")) {
                // ܂ɂ悭ԈႢȂ̂ŁA~悤ɎdlύX܂B
                throw new IllegalArgumentException(bundle.getXml2csclassErr006(
                        argClassStructure.getName(), field.getName()));
            }

            final String fieldNameAdjustered = (getNameAdjust() == false ? field
                    .getName()
                    : BlancoNameAdjuster.toClassName(field.getName()));

            final BlancoCgField field1 = fCgFactory.createField("f"
                    + fieldNameAdjustered, field.getType(), bundle
                    .getXml2csclassFieldName(field.getName()));
            fCgClass.getFieldList().add(field1);

            field1.getLangDoc().getDescriptionList().add(
                    bundle.getXml2csclassFieldType(field.getType()));
            if (field.getDefault() != null) {
                field1.getLangDoc().getDescriptionList().add(
                        bundle.getXml2csclassFieldDefault(field.getDefault()));
                if ("System.String".equals(field.getType())
                        || "string".equals(field.getType())) {
                    field1.setDefault("\""
                            + BlancoJavaSourceUtil
                                    .escapeStringAsJavaSource(field
                                            .getDefault()) + "\"");
                } else if (field.getType().equals("bool")
                        || field.getType().equals("short")
                        || field.getType().equals("int")
                        || field.getType().equals("long")) {
                    field1.setDefault(field.getDefault());
                } else if (field.getType().equals("System.Boolean")
                        || field.getType().equals("System.Int32")
                        || field.getType().equals("System.Int64")) {
                    field1.setDefault(field.getDefault());
                } else if (field.getType().equals("System.Int16")) {
                    field1.setDefault(field.getDefault());
                } else if (field.getType().equals("System.Decimal")) {
                    field1
                            .setDefault("new Decimal(" + field.getDefault()
                                    + ")");
                } else if (field.getType().equals("decimal")) {
                    field1
                            .setDefault("new decimal(" + field.getDefault()
                                    + ")");
                } else if (field.getType().equals(
                        "System.Collections.ArrayList")) {
                    // ArrayList̏ꍇɂ́A^ꂽ̂܂܍̗p܂B
                    fCgSourceFile.getImportList().add(
                            "System.Collections.ArrayList");
                    field1.setDefault(field.getDefault());
                } else {
                    throw new IllegalArgumentException(bundle
                            .getXml2csclassErr005(argClassStructure.getName(),
                                    field.getName(), field.getDefault(), field
                                            .getType()));
                }
            }
            if (field.getDescription() != null) {
                final String[] lines = BlancoValueObjectDotNetUtil
                        .escapeStringAsCsDocWithNewLine(field.getDescription());
                for (int index = 0; index < lines.length; index++) {
                    field1.getLangDoc().getDescriptionList().add(lines[index]);
                }
            }

            {
                final BlancoCgMethod cgMethod = fCgFactory.createMethod("Set"
                        + fieldNameAdjustered, bundle
                        .getXml2csclassSetJavadoc01(field.getName()));
                fCgClass.getMethodList().add(cgMethod);

                cgMethod.getLangDoc().getDescriptionList().add(
                        bundle.getXml2csclassSetJavadoc02(field.getType()));
                if (field.getDescription() != null) {
                    final String[] lines = BlancoValueObjectDotNetUtil
                            .escapeStringAsCsDocWithNewLine(field
                                    .getDescription());
                    for (int index = 0; index < lines.length; index++) {
                        cgMethod.getLangDoc().getDescriptionList().add(
                                lines[index]);
                    }
                }
                cgMethod.getParameterList().add(
                        fCgFactory.createParameter("arg" + fieldNameAdjustered,
                                field.getType(), bundle
                                        .getXml2csclassSetArgJavadoc(field
                                                .getName())));

                // \bh̎
                cgMethod.getLineList().add(
                        "f" + fieldNameAdjustered + " = " + "arg"
                                + fieldNameAdjustered + ";");
            }

            {
                final BlancoCgMethod cgMethod = fCgFactory.createMethod("Get"
                        + fieldNameAdjustered, bundle
                        .getXml2csclassGetJavadoc01(field.getName()));
                fCgClass.getMethodList().add(cgMethod);

                // \bh̃VOj`w
                cgMethod.getLangDoc().getDescriptionList().add(
                        bundle.getXml2csclassGetJavadoc02(field.getType()));
                if (field.getDefault() != null) {
                    cgMethod.getLangDoc().getDescriptionList().add(
                            bundle.getXml2csclassGetArgJavadoc(field
                                    .getDefault()));
                }
                if (field.getDescription() != null) {
                    final String[] lines = BlancoValueObjectDotNetUtil
                            .escapeStringAsCsDocWithNewLine(field
                                    .getDescription());
                    for (int index = 0; index < lines.length; index++) {
                        cgMethod.getLangDoc().getDescriptionList().add(
                                lines[index]);
                    }
                }

                cgMethod
                        .setReturn(fCgFactory.createReturn(field.getType(),
                                bundle.getXml2csclassGetReturnJavadoc(field
                                        .getName())));
                // \bh̎
                cgMethod.getLineList().add(
                        "return f" + fieldNameAdjustered + ";");
            }
        }

        // WꂽɎۂ̃\[XR[hB
        BlancoCgTransformerFactory.getCsSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂݒ肵܂B
     * 
     * @param isNameAdjust
     *            Oό`sǂB
     */
    public void setNameAdjust(final boolean isNameAdjust) {
        fNameAdjust = isNameAdjust;
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂ擾܂B
     * 
     * @return Oό`sǂB
     */
    public boolean getNameAdjust() {
        return fNameAdjust;
    }
}
