/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.dbmetadata.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.dbmetadata.task.valueobject.BlancoDbMetaDataMeta2CsvProcessInput;

/**
 * Apache Ant^XN [BlancoDbMetaDataMeta2Csv]̃NXB
 *
 * f[^x[X^񂩂CSV邽߂AntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.dbmetadata.task]BlancoDbMetaDataMeta2CsvBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancodbmetadatameta2csv&quot; classname=&quot;blanco.dbmetadata.task.BlancoDbMetaDataMeta2CsvTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoDbMetaDataMeta2CsvTask extends Task {
    /**
     * f[^x[X^񂩂CSV邽߂AntTaskłB
     */
    protected BlancoDbMetaDataMeta2CsvProcessInput fInput = new BlancoDbMetaDataMeta2CsvProcessInput();

    /**
     * tB[h [jdbcdriver] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcdriverProcessed = false;

    /**
     * tB[h [jdbcurl] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcurlProcessed = false;

    /**
     * tB[h [jdbcuser] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcuserProcessed = false;

    /**
     * tB[h [jdbcpassword] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldJdbcpasswordProcessed = false;

    /**
     * tB[h [schema] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldSchemaProcessed = false;

    /**
     * tB[h [table] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTableProcessed = false;

    /**
     * tB[h [targetdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * tB[h [tmpdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTmpdirProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[jdbcdriver]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * JDBChCow肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcdriver(final String arg) {
        fInput.setJdbcdriver(arg);
        fIsFieldJdbcdriverProcessed = true;
    }

    /**
     * Ant^XN[jdbcdriver]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * JDBChCow肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcdriver() {
        return fInput.getJdbcdriver();
    }

    /**
     * Ant^XN[jdbcurl]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * JDBCڑURLw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcurl(final String arg) {
        fInput.setJdbcurl(arg);
        fIsFieldJdbcurlProcessed = true;
    }

    /**
     * Ant^XN[jdbcurl]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * JDBCڑURLw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcurl() {
        return fInput.getJdbcurl();
    }

    /**
     * Ant^XN[jdbcuser]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcuser(final String arg) {
        fInput.setJdbcuser(arg);
        fIsFieldJdbcuserProcessed = true;
    }

    /**
     * Ant^XN[jdbcuser]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcuser() {
        return fInput.getJdbcuser();
    }

    /**
     * Ant^XN[jdbcpassword]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     *
     * @param arg Zbgl
     */
    public void setJdbcpassword(final String arg) {
        fInput.setJdbcpassword(arg);
        fIsFieldJdbcpasswordProcessed = true;
    }

    /**
     * Ant^XN[jdbcpassword]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getJdbcpassword() {
        return fInput.getJdbcpassword();
    }

    /**
     * Ant^XN[schema]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 5<br>
     * XL[}BOraclȅꍇɂ̓[U^Kv܂B<br>
     *
     * @param arg Zbgl
     */
    public void setSchema(final String arg) {
        fInput.setSchema(arg);
        fIsFieldSchemaProcessed = true;
    }

    /**
     * Ant^XN[schema]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 5<br>
     * XL[}BOraclȅꍇɂ̓[U^Kv܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getSchema() {
        return fInput.getSchema();
    }

    /**
     * Ant^XN[table]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 6<br>
     * w肳ꂽꍇɂ́A̕\݂̂܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTable(final String arg) {
        fInput.setTable(arg);
        fIsFieldTableProcessed = true;
    }

    /**
     * Ant^XN[table]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 6<br>
     * w肳ꂽꍇɂ́A̕\݂̂܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTable() {
        return fInput.getTable();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 7<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 7<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     * ftHgl[blanco.db]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 8<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
        fIsFieldTmpdirProcessed = true;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 8<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoDbMetaDataMeta2CsvTask begin.");

        // ڔԍ[1]AAgr[g[jdbcdriver]͕K{͂łB̓`FbNs܂B
        if (fIsFieldJdbcdriverProcessed == false) {
            throw new BuildException("K{Agr[g[jdbcdriver]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[jdbcurl]͕K{͂łB̓`FbNs܂B
        if (fIsFieldJdbcurlProcessed == false) {
            throw new BuildException("K{Agr[g[jdbcurl]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[3]AAgr[g[jdbcuser]͕K{͂łB̓`FbNs܂B
        if (fIsFieldJdbcuserProcessed == false) {
            throw new BuildException("K{Agr[g[jdbcuser]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[4]AAgr[g[jdbcpassword]͕K{͂łB̓`FbNs܂B
        if (fIsFieldJdbcpasswordProcessed == false) {
            throw new BuildException("K{Agr[g[jdbcpassword]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- jdbcdriver:[" + getJdbcdriver() + "]");
            System.out.println("- jdbcurl:[" + getJdbcurl() + "]");
            System.out.println("- jdbcuser:[" + getJdbcuser() + "]");
            System.out.println("- jdbcpassword:[" + getJdbcpassword() + "]");
            System.out.println("- schema:[" + getSchema() + "]");
            System.out.println("- table:[" + getTable() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoDbMetaDataMeta2CsvProcessC^tF[X blanco.dbmetadata.taskpbP[W BlancoDbMetaDataMeta2CsvProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoDbMetaDataMeta2CsvProcess proc = new BlancoDbMetaDataMeta2CsvProcessImpl();
            if (proc.execute(fInput) != BlancoDbMetaDataMeta2CsvBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
