// ̃\[XR[h blanco Frameworkɂ莩܂B
// <summary>blancoCsvŗps[eBeBNXB</summary>
using System;
using System.IO;
using System.Text;

using blanco.sample.csv.io;

namespace blanco.sample.csv.util
{
    /// <summary>blancoCsvŗps[eBeBNXB</summary>
    /// <remarks>
    /// <newpara>̃t@Cblanco Frameworkɂ莩Ă܂B</newpara>
    /// </remarks>
    public class BlancoCsvRuntimeUtil
    {
        /// <summary>^ꂽReader ^ꂽf~^găg[No܂B</summary>
        /// <param name="argReader">^ꂽ[_B</param>
        /// <param name="delimiter">f~^</param>
        /// <param name="isEndOfLine">s̏I[ł̂ǂtOB</param>
        /// <returns>oꂽg[NB͂⃊[_̏ꍇɂnullԂ܂B</returns>
        public static string ReadToken(TextReader argReader, char delimiter, bool isEndOfLine)
        {
            if (argReader == null)
            {
                throw new ArgumentException("ReadToken\bh̃[_null^܂B");
            }
            StringBuilder buffer = new StringBuilder();
            for (;;) {
                int iRead = argReader.Read();
                if (iRead < 0) {
                    // I[ɓBB
                    if (isEndOfLine == false) {
                        throw new BlancoCsvIOException("s̏I[łȂ̂ɂւ炸f~^ꂸɍsIĂ܂܂B");
                    }
                    break;
                }
                if (iRead == delimiter) {
                    if (isEndOfLine) {
                        throw new BlancoCsvIOException("s̏I[łׂɂւ炸f~^܂B");
                    }
                    break;
                } else {
                    buffer.Append((char) iRead);
                }
            }
            return buffer.ToString();
        }

        /// <summary>^ꂽReader _uNI[gt ^ꂽf~^găg[No܂B</summary>
        /// <param name="argReader">^ꂽ[_B</param>
        /// <param name="delimiter">f~^B</param>
        /// <returns>oꂽg[NB͂⃊[_̏ꍇɂnullԂ܂B</returns>
        public static string ReadTokenWithQuote(TextReader argReader, char delimiter)
        {
            if (argReader == null)
            {
                throw new ArgumentException("ReadTokenWithQuote\bh̃[_null^܂B");
            }
            StringBuilder buffer = new StringBuilder();
            bool isStringStarted = false;
            bool isStringEnded = false;
            // OǂݍŁǍ㖢̃f[^ێ܂BێȂꍇɂ -1 ~܂B
            int previousChar = -1;
            for (;;) {
                int iRead = -1;
                if (previousChar < 0)
                {
                    iRead = argReader.Read();
                    if (iRead < 0)
                    {
                        // I[ɓBB
                        break;
                    }
                }
                else
                {
                    iRead = previousChar;
                    previousChar = -1;
                }
                if (isStringStarted == false) {
                    if (iRead != '"') {
                        throw new BlancoCsvIOException("_uNI[gŕ񂪊Jn܂B");
                    }
                    // _uNI[e[V͓ǂݔ΂܂B
                    isStringStarted = true;
                } else if (isStringEnded) {
                    if (iRead == delimiter) {
                        // I[ɓB܂B
                        break;
                    }
                    throw new BlancoCsvIOException("_uNI[gɂ镶Iɕ񂪗^܂B");
                } else {
                    // ʏ̕GA
                    if (iRead == '"') {
                        // _uNI[gd˂ꂽ̂łȂǂ`FbN܂B
                        previousChar = argReader.Read();
                        if (previousChar == '"') {
                            // GXP[vꂽ_uNI[g
                            // 2łЂƂȂ̂ŁAЂƂ͓ǂݎ̂Ă܂B
                            buffer.Append((char) iRead);
                            previousChar = -1;
                        } else {
                            // _uNI[gɂGXP[vł͂܂łB
                            // ͏I[ӖĂ܂B
                            isStringEnded = true;
                        }
                    } else {
                        buffer.Append((char) iRead);
                    }
                }
            }
            if (isStringStarted == false) {
                throw new BlancoCsvIOException("_uNI[gKvȕł̂Ƀ_uNI[gɂJn܂łB");
            }
            if (isStringEnded == false) {
                throw new BlancoCsvIOException("_uNI[gKvȕł̂Ƀ_uNI[gɂI܂łB");
            }
            return buffer.ToString();
        }

        /// <summary>_uNI[gGXP[vt̕擾܂B</summary>
        /// <param name="value">oB</param>
        /// <returns>_uNI[gGXP[vt̕B</returns>
        public static string GetTokenWithQuote(string value)
        {
            if (value == null)
            {
                throw new ArgumentException("GetTokenWithQuote\bhvaluenull^܂B");
            }
            StringWriter writer = new StringWriter();
            writer.Write("\"");

            StringReader reader = new StringReader(value);
            for (;;) {
                int iRead = reader.Read();
                if (iRead < 0) {
                    // I[ɓBB
                    break;
                }
                if (iRead == '\"') {
                    // _uNI[g͓dŏo܂B
                    writer.Write("\"\"");
                } else {
                    writer.Write((char) iRead);
                }
            }

            writer.Write("\"");
            writer.Close();
            return writer.ToString();
        }

        /// <summary>oCgzɕϊ܂B</summary>
        /// <param name="inputString">ϊ̕B</param>
        /// <returns>oCgzɕϊ̕B</returns>
        public static byte[] GetBytes(string inputString)
        {
            if (inputString == null)
            {
                throw new ArgumentException("GetBytes\bhnull^܂B");
            }
            // oCgzɕϊ܂B
            byte[] inputBytes = Encoding.Unicode.GetBytes(inputString);
            // GR[fBO擾܂Bł̓VtgJISւ̃GR[fBO擾Ă܂B
            //TODO: `Ŏw肳ĂGR[hKv܂B
            Encoding targetEncoding = Encoding.GetEncoding(932);
            // ۂɃR[hϊB
            return Encoding.Convert(Encoding.Unicode, targetEncoding, inputBytes);
        }
    }
}
