/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.csv.resourcebundle.BlancoCsvDotNetResourceBundle;
import blanco.csv.resourcebundle.BlancoCsvWriterDotNetResourceBundle;
import blanco.csv.valueobject.BlancoCsvFieldStructureDotNet;
import blanco.csv.valueobject.BlancoCsvStructureDotNet;

public class BlancoCsvExpandWriterDotNet {
    final BlancoCsvDotNetResourceBundle bundle = new BlancoCsvDotNetResourceBundle();

    final BlancoCsvWriterDotNetResourceBundle writerBundle = new BlancoCsvWriterDotNetResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    public void expand(final BlancoCsvStructureDotNet processStructure,
            final File directoryTarget) {
        final String className = BlancoNameAdjuster
                .toClassName(processStructure.getFileDefinitionId())
                + writerBundle.getClassNameSuffix();

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        // BlancoCgObjectFactoryNX̃CX^X擾܂B
        fCgFactory = BlancoCgObjectFactory.getInstance();

        fCgSourceFile = fCgFactory.createSourceFile(processStructure
                .getPackageName()
                + writerBundle.getPackagePrefix(), null);
        fCgSourceFile.setEncoding(fEncoding);

        // NX쐬܂B
        fCgClass = fCgFactory.createClass(className, null);
        fCgSourceFile.getClassList().add(fCgClass);

        // SystemOԂusing܂B
        fCgSourceFile.getImportList().add("System.String");
        fCgSourceFile.getLangDoc().getDescriptionList().add(
                writerBundle.getFilecomment());

        fCgClass
                .getLangDoc()
                .getDescriptionList()
                .add(
                        writerBundle
                                .getClasscomment01(processStructure
                                        .getFileDefinitionId()
                                        + (processStructure
                                                .getFileDescription() == null ? ""
                                                : "/"
                                                        + processStructure
                                                                .getFileDescription())));
        fCgClass.getLangDoc().getDescriptionList().add(
                writerBundle.getClasscomment02());
        if (processStructure.getEncoding() == null) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    writerBundle.getClasscomment03Case01());
        } else {
            fCgClass.getLangDoc().getDescriptionList().add(
                    writerBundle.getClasscomment03Case02(processStructure
                            .getEncoding()));
        }
        fCgClass.getLangDoc().getDescriptionList().add(
                writerBundle.getClasscomment04());

        {
            final BlancoCgField cgField = fCgFactory.createField(writerBundle
                    .getFieldWriterName(), writerBundle.getFieldWriterType(),
                    null);
            fCgClass.getFieldList().add(cgField);

            cgField.getLangDoc().getDescriptionList().add(
                    writerBundle.getFieldWriterJavadoc01());
            cgField.getLangDoc().getDescriptionList().add(
                    writerBundle.getFieldWriterJavadoc02());
        }

        {
            final BlancoCgField cgField = fCgFactory.createField(writerBundle
                    .getFieldLineCounterName(), writerBundle
                    .getFieldLineCounterType(), null);
            fCgClass.getFieldList().add(cgField);

            cgField.getLangDoc().getDescriptionList().add(
                    writerBundle.getFieldLineCounterJavadoc01());
            cgField.getLangDoc().getDescriptionList().add(
                    writerBundle.getFieldLineCounterJavadoc02());
            cgField.setDefault(writerBundle.getFieldLineCounterDefault());
        }

        {
            // uvΉ
            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoCsvFieldStructureDotNet csvField = (BlancoCsvFieldStructureDotNet) processStructure
                        .getListField().get(indexField);

                if (csvField.getType().equals("System.DateTime")) {
                    final BlancoCgField cgField = fCgFactory.createField(
                            writerBundle.getFieldSimpleDateFormatNamePrefix()
                                    + BlancoNameAdjuster.toClassName(csvField
                                            .getName()), "string", null);
                    fCgClass.getFieldList().add(cgField);

                    cgField.getLangDoc().getDescriptionList().add(
                            writerBundle
                                    .getFieldSimpleDateFormatJavadoc01(csvField
                                            .getName()));
                    cgField.getLangDoc().getDescriptionList().add(
                            writerBundle.getFieldSimpleDateFormatJavadoc02());
                }
            }
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(className,
                    null);
            fCgClass.getMethodList().add(cgMethod);

            // \bh̃VOj`w
            cgMethod.setConstructor(true);
            cgMethod.getLangDoc().getDescriptionList().add(
                    writerBundle.getConstructor01Javadoc01());
            cgMethod.getLangDoc().getDescriptionList().add(
                    writerBundle.getConstructor01Javadoc02());
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("arg", writerBundle
                            .getConstructor01Arg01Type(), writerBundle
                            .getConstructor01Arg01Javadoc01()));

            // \bh̎
            cgMethod.getLineList().add("fWriter = arg;");

            // uvΉ
            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoCsvFieldStructureDotNet csvField = (BlancoCsvFieldStructureDotNet) processStructure
                        .getListField().get(indexField);

                if (csvField.getType().equals("System.DateTime")) {
                    cgMethod
                            .getLineList()
                            .add(
                                    "fSimpleDateFormat"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName())
                                            + " = "
                                            + (csvField.getFormat() == null ? "\"yyyy/MM/dd\""
                                                    : "\""
                                                            + csvField
                                                                    .getFormat()
                                                            + "\"") + ";");
                }
            }
        }

        if (processStructure.getTitleRow().equals("title with quote")
                || processStructure.getTitleRow().equals("title without quote")) {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "writeTitle", writerBundle.getWritetitleJavadoc01());
            fCgClass.getMethodList().add(cgMethod);

            cgMethod.getLangDoc().getDescriptionList().add(
                    writerBundle.getWritetitleJavadoc02());
            if (processStructure.getTitleRow().equals("title with quote")) {
                cgMethod.getLangDoc().getDescriptionList().add(
                        writerBundle.getWritetitleJavadoc03());
            }

            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoCsvFieldStructureDotNet csvField = (BlancoCsvFieldStructureDotNet) processStructure
                        .getListField().get(indexField);
                final String delimiter = (indexField != 0 ? processStructure
                        .getDelimiter() : "");
                final String quote = (processStructure.getTitleRow().equals(
                        "title with quote") ? BlancoJavaSourceUtil
                        .escapeStringAsJavaSource("\"") : "");
                cgMethod.getLineList().add(
                        "fWriter.Write(\""
                                + delimiter
                                + quote
                                + BlancoJavaSourceUtil
                                        .escapeStringAsJavaSource(csvField
                                                .getDescription()) + quote
                                + "\");");
            }
            cgMethod.getLineList().add("fWriter.WriteLine();");
        }

        final String recordClassName = processStructure.getPackageName()
                + ".record."
                + BlancoNameAdjuster.toClassName(processStructure
                        .getFileDefinitionId()) + "CsvRecord";

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "WriteRecord", writerBundle.getWriterecordJavadoc01());
            fCgClass.getMethodList().add(cgMethod);

            // \bh̃VOj`w
            cgMethod.getLangDoc().getDescriptionList().add(
                    writerBundle.getWriterecordJavadoc02());
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("record", recordClassName,
                            writerBundle.getWriterecordArg01Javadoc()));

            // \bh̎
            cgMethod.getLineList().add("string writeToken = null;");
            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoCsvFieldStructureDotNet csvField = (BlancoCsvFieldStructureDotNet) processStructure
                        .getListField().get(indexField);

                if (indexField != 0) {
                    cgMethod.getLineList().add(
                            "fWriter.Write('" + processStructure.getDelimiter()
                                    + "');");
                }

                cgMethod.getLineList().add("");
                cgMethod
                        .getLineList()
                        .add(
                                writerBundle
                                        .getWriterecordLine01(
                                                (csvField.getNo() == null ? ""
                                                        : bundle
                                                                .getFieldNo(csvField
                                                                        .getNo())
                                                                + " "),
                                                csvField.getName()
                                                        + (csvField
                                                                .getDescription() == null ? ""
                                                                : "/"
                                                                        + csvField
                                                                                .getDescription())));

                if (csvField.getType().equals("string")
                        || csvField.getType().equals("string(quote)")) {
                    if (csvField.getRequired()) {
                        // K{ځB
                        cgMethod.getLineList()
                                .add(
                                        "if (record.Get"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "() == null) {");
                        cgMethod
                                .getLineList()
                                .add(
                                        "throw new BlancoCsvIOException(\""
                                                + bundle
                                                        .getCsvWriterErr004(getLocationString(
                                                                indexField,
                                                                csvField
                                                                        .getNo(),
                                                                csvField
                                                                        .getName(),
                                                                csvField
                                                                        .getDescription()))
                                                + "\");");
                        cgMethod.getLineList().add("}");
                        cgMethod.getLineList()
                                .add(
                                        "if (record.Get"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "().Length == 0) {");
                        cgMethod
                                .getLineList()
                                .add(
                                        "throw new BlancoCsvIOException(\""
                                                + bundle
                                                        .getCsvWriterErr005(getLocationString(
                                                                indexField,
                                                                csvField
                                                                        .getNo(),
                                                                csvField
                                                                        .getName(),
                                                                csvField
                                                                        .getDescription()))
                                                + "\");");
                        cgMethod.getLineList().add("}");
                        cgMethod.getLineList()
                                .add(
                                        "writeToken = record.Get"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "();");
                    } else {
                        // CӍڂł̂ null͒0̕ւƓǂݑւ܂B
                        cgMethod
                                .getLineList()
                                .add(
                                        "// CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B");
                        cgMethod.getLineList().add("// ̏ꍇɂ͒`FbN͍s܂B");
                        cgMethod
                                .getLineList()
                                .add(
                                        "writeToken = record.Get"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "() == null ? \"\" : record.Get"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "();");

                        // ifJnԂ̂܂܂ɂ܂B
                        cgMethod.getLineList().add(
                                "if (writeToken.Length > 0) {");
                    }
                } else if (csvField.getType().equals("int")
                        || csvField.getType().equals("long")
                        || csvField.getType().equals("decimal")
                        || csvField.getType().equals("System.DateTime")) {
                    if (csvField.getRequired()) {
                        // K{ځB
                        if (csvField.getType().equals("System.DateTime") == false) {
                            cgMethod.getLineList().add(
                                    "writeToken = record.Get"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName())
                                            + "().ToString();");
                        } else {
                            cgMethod.getLineList().add(
                                    "writeToken = record.Get"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName())
                                            + "().ToString(fSimpleDateFormat"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName()) + ");");
                        }
                    } else {
                        // CӍځB
                        cgMethod.getLineList()
                                .add(
                                        "if (record.Get"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "() == " + csvField.getType()
                                                + ".MinValue) {");
                        cgMethod.getLineList().add("writeToken = \"\";");
                        cgMethod.getLineList().add("} else {");
                        // ifJnԂ̂܂܂ɂ܂B

                        if (csvField.getType().equals("System.DateTime") == false) {
                            cgMethod.getLineList().add(
                                    "writeToken = record.Get"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName())
                                            + "().ToString();");
                        } else {
                            cgMethod.getLineList().add(
                                    "writeToken = record.Get"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName())
                                            + "().ToString(fSimpleDateFormat"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName()) + ");");
                        }
                    }
                } else {
                    cgMethod.getLineList().add(
                            bundle.getNotSupportedType(csvField.getType()));
                }

                if (csvField.getRequired()) {
                    // K{ځB
                    if (csvField.getType().equals("string")
                            || csvField.getType().equals("string(quote)")) {
                        cgMethod.getLineList().add("if (writeToken == null) {");
                        cgMethod
                                .getLineList()
                                .add(
                                        "throw new BlancoCsvIOException(\""
                                                + bundle
                                                        .getCsvWriterErr004(getLocationString(
                                                                indexField,
                                                                csvField
                                                                        .getNo(),
                                                                csvField
                                                                        .getName(),
                                                                csvField
                                                                        .getDescription()))
                                                + "\");");
                        cgMethod.getLineList().add("}");
                    } else if (csvField.getType().equals("int")
                            || csvField.getType().equals("long")
                            || csvField.getType().equals("decimal")
                            || csvField.getType().equals("System.DateTime")) {
                        cgMethod.getLineList()
                                .add(
                                        "if (record.Get"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "() == " + csvField.getType()
                                                + ".MinValue) {");
                        cgMethod
                                .getLineList()
                                .add(
                                        "throw new BlancoCsvIOException(\""
                                                + bundle
                                                        .getCsvWriterErr006(getLocationString(
                                                                indexField,
                                                                csvField
                                                                        .getNo(),
                                                                csvField
                                                                        .getName(),
                                                                csvField
                                                                        .getDescription()))
                                                + "\");");
                        cgMethod.getLineList().add("}");
                    }
                }

                if (csvField.getMinLength() != null) {
                    // ^̗pǉ܂B
                    fCgSourceFile.getImportList().add(
                            processStructure.getRuntimePackage()
                                    + ".util.BlancoCsvRuntimeUtil");

                    cgMethod.getLineList().add(
                            "if (BlancoCsvRuntimeUtil.GetBytes(writeToken"
                                    + ").Length < " + csvField.getMinLength()
                                    + ") {");
                    cgMethod.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvWriterErr001(
                                            getLocationString(indexField,
                                                    csvField.getNo(), csvField
                                                            .getName(),
                                                    csvField.getDescription()),
                                            csvField.getMinLength()) + "\");");
                    cgMethod.getLineList().add("}");
                }
                if (csvField.getMaxLength() != null) {
                    // ^̗pǉ܂B
                    fCgSourceFile.getImportList().add(
                            processStructure.getRuntimePackage()
                                    + ".util.BlancoCsvRuntimeUtil");

                    cgMethod.getLineList().add(
                            "if (BlancoCsvRuntimeUtil.GetBytes(writeToken"
                                    + ").Length > " + csvField.getMaxLength()
                                    + ") {");
                    cgMethod.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvWriterErr002(
                                            getLocationString(indexField,
                                                    csvField.getNo(), csvField
                                                            .getName(),
                                                    csvField.getDescription()),
                                            csvField.getMaxLength()) + "\");");
                    cgMethod.getLineList().add("}");
                }

                if (csvField.getRequired()) {
                } else {
                    // CӍڂ̓JbRJςȂł̂ŁAŕ܂B
                    cgMethod.getLineList().add("}");
                }

                if (csvField.getType().equals("string")) {
                    cgMethod.getLineList().add(
                            "if (writeToken.IndexOf(\""
                                    + processStructure.getDelimiter()
                                    + "\") >= 0) {");
                    cgMethod.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvWriterErr003(
                                            getLocationString(indexField,
                                                    csvField.getNo(), csvField
                                                            .getName(),
                                                    csvField.getDescription()),
                                            processStructure.getDelimiter())
                                    + "\");");
                    cgMethod.getLineList().add("}");
                    cgMethod.getLineList().add("fWriter.Write(writeToken);");
                } else if (csvField.getType().equals("string(quote)")) {
                    // ^̗pǉ܂B
                    fCgSourceFile.getImportList().add(
                            processStructure.getRuntimePackage()
                                    + ".util.BlancoCsvRuntimeUtil");

                    cgMethod.getLineList().add(
                            writerBundle.getWriterecordLine02());
                    cgMethod
                            .getLineList()
                            .add(
                                    "fWriter.Write(BlancoCsvRuntimeUtil.GetTokenWithQuote(writeToken));");
                } else {
                    cgMethod.getLineList().add("fWriter.Write(writeToken);");
                }
            }
            cgMethod.getLineList().add("");
            cgMethod.getLineList().add(writerBundle.getWriterecordLine03());
            cgMethod.getLineList().add("fWriter.WriteLine();");
            cgMethod.getLineList().add("fLineCounter++;");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "GetLineCounter", "ݏ̍sJE^Ԃ܂B");
            fCgClass.getMethodList().add(cgMethod);

            // \bh̃VOj`w
            cgMethod.setReturn(fCgFactory.createReturn("long", "ݏ̍sJE^B"));

            // \bh̎
            cgMethod.getLineList().add("return fLineCounter;");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod("Flush",
                    writerBundle.getFlushJavadoc01());
            fCgClass.getMethodList().add(cgMethod);

            // \bh̃VOj`w
            cgMethod.getLangDoc().getDescriptionList().add(
                    writerBundle.getFlushJavadoc02());

            // \bh̎
            cgMethod.getLineList().add("fWriter.Flush();");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod("Close",
                    writerBundle.getCloseJavadoc01());
            fCgClass.getMethodList().add(cgMethod);

            // \bh̃VOj`w
            cgMethod.getLangDoc().getDescriptionList().add(
                    writerBundle.getCloseJavadoc02());

            // \bh̎
            cgMethod.getLineList().add("fWriter.Close();");

        }

        // WꂽɎۂ̃\[XR[hB
        BlancoCgTransformerFactory.getCsSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    private String getLocationString(int indexField, String fieldNo,
            String fieldName, String fieldDescription) {
        return writerBundle.getGetlocationstringLine01("" + (indexField + 1),
                (fieldNo == null ? "" : bundle.getFieldNo(fieldNo) + " "),
                fieldName
                        + (fieldDescription == null ? "" : "/"
                                + fieldDescription));
    }
}
