/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.csv.resourcebundle.BlancoCsvIOExceptionDotNetResourceBundle;
import blanco.csv.valueobject.BlancoCsvStructureDotNet;

public class BlancoCsvExpandIOExceptionDotNet {
    private final BlancoCsvIOExceptionDotNetResourceBundle bundle = new BlancoCsvIOExceptionDotNetResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    public void expand(final BlancoCsvStructureDotNet processStructure,
            final File directoryTarget) {

        final String packageName = processStructure.getRuntimePackage()
                + bundle.getPackagePrefix();

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        // BlancoCgObjectFactoryNX̃CX^X擾܂B
        fCgFactory = BlancoCgObjectFactory.getInstance();

        fCgSourceFile = fCgFactory.createSourceFile(packageName, null);
        fCgSourceFile.setEncoding(fEncoding);

        // NX쐬܂B
        fCgClass = fCgFactory.createClass(bundle.getClassName(), null);
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getExtendClassList().add(
                fCgFactory.createType(bundle.getSuperclassName()));
        fCgSourceFile.setDescription(bundle.getFilecomment());

        fCgClass.getLangDoc().getDescriptionList().add(
                bundle.getClasscomment01());
        fCgClass.getLangDoc().getDescriptionList().add(
                bundle.getClasscomment02());

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(bundle
                    .getClassName(), bundle.getConstructor01Comment());
            fCgClass.getMethodList().add(cgMethod);
            cgMethod.setConstructor(true);

            // qݒB
            cgMethod.setSuperclassInvocation("base(message)");

            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("message", bundle
                            .getConstructor01Arg01Type(), bundle
                            .getConstructor01Arg01Comment()));
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(bundle
                    .getClassName(), bundle.getConstructor01Comment());
            fCgClass.getMethodList().add(cgMethod);
            cgMethod.setConstructor(true);

            // qݒB
            cgMethod.setSuperclassInvocation("base(" + "message"
                    + ", innerException)");

            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("message", bundle
                            .getConstructor01Arg01Type(), bundle
                            .getConstructor01Arg01Comment()));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("innerException",
                            "System.Exception", "Ƃ̗OIuWFNgB"));
        }

        // WꂽɎۂ̃\[XR[hB
        BlancoCgTransformerFactory.getCsSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
