/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.csv.valueobject.BlancoCsvFieldStructureDotNet;
import blanco.csv.valueobject.BlancoCsvStructureDotNet;
import blanco.valueobjectdotnet.BlancoValueObjectDotNetXml2SourceFile;
import blanco.valueobjectdotnet.valueobject.BlancoValueObjectDotNetClassStructure;
import blanco.valueobjectdotnet.valueobject.BlancoValueObjectDotNetFieldStructure;

public class BlancoCsvExpandRecordDotNet {
    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * R[hWJ܂B
     * 
     * @param processStructure
     * @param direcotryValueObjectWork
     * @param directoryTarget
     * @throws IOException
     * @throws TransformerException
     */
    public void expand(final BlancoCsvStructureDotNet processStructure,
            final File direcotryValueObjectWork, final File directoryTarget)
            throws IOException, TransformerException {
        final String className = BlancoNameAdjuster
                .toClassName(processStructure.getFileDefinitionId())
                + "CsvRecord";
        final String packageName = processStructure.getPackageName()
                + ".record";

        final BlancoValueObjectDotNetClassStructure voStructure = new BlancoValueObjectDotNetClassStructure();

        // O
        voStructure.setName(className);
        voStructure.setPackage(packageName);
        voStructure.setDescription("blancoCsvDotNett@C`쐬ꂽR[hNX");
        voStructure.setFilecomment("t@C`["
                + processStructure.getFileDefinitionId()
                + (processStructure.getFileDescription() == null ? "" : "/"
                        + processStructure.getFileDescription())
                + "]̃R[hNX");

        for (int indexField = 0; indexField < processStructure.getListField()
                .size(); indexField++) {
            final BlancoValueObjectDotNetFieldStructure voField = new BlancoValueObjectDotNetFieldStructure();
            voStructure.getFieldList().add(voField);

            final BlancoCsvFieldStructureDotNet csvField = (BlancoCsvFieldStructureDotNet) processStructure
                    .getListField().get(indexField);

            boolean isQuoted = false;
            String actualType = csvField.getType();
            if (csvField.getType().endsWith("(quote)")) {
                // NI[gw肪ꍇɂ́A^̂(quote)܂B
                actualType = csvField.getType().substring(0,
                        csvField.getType().length() - "(quote)".length());
                isQuoted = true;
            }

            if (csvField.getNo() != null) {
                voField.setNo(csvField.getNo());
            }

            voField.setName(csvField.getName());
            voField.setType(actualType);

            String description = "";
            if (csvField.getNo() != null) {
                description += ("ڔԍ: " + csvField.getNo() + "\n");
            }
            if (csvField.getDescription() != null) {
                description += ("ڂ̐: " + csvField.getDescription() + "\n");
            }
            if (isQuoted) {
                description += ("̓_uNI[gēo͂܂B\n");
            }

            if (csvField.getMinLength() != null) {
                description += ("MIN: " + csvField.getMinLength() + "\n");
            }
            if (csvField.getMaxLength() != null) {
                description += ("MAX: " + csvField.getMaxLength() + "\n");
            }
            if (csvField.getRequired()) {
                description += ("K{\n");
            }

            voField.setDescription(description);

            if (csvField.getDefault() != null) {
                voField.setDefault(csvField.getDefault());
            }
        }

        final BlancoValueObjectDotNetXml2SourceFile xml2Source = new BlancoValueObjectDotNetXml2SourceFile();
        xml2Source.setEncoding(fEncoding);
        xml2Source.structure2Source(voStructure, directoryTarget);
    }
}
