/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * EclipsevOC [BlancoCsv]̃EBU[hNX
 */
package blanco.plugin.csv.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

import blanco.plugin.csv.BlancoCsvPluginConstants;

/**
 * EclipsevOC [BlancoCsv]̃EBU[hNXB
 *
 * blancoCsvvOC̃\[XR[ĥ߂̒`łB<br>
 */
public abstract class AbstractBlancoCsvWizard extends Wizard implements INewWizard {
    /**
     */
    protected ISelection selection;

    /**
     */
    public AbstractBlancoCsvWizard() {
        super();
        setNeedsProgressMonitor(true);
        setWindowTitle("blancoCsv Wizard");
    }

    /**
     *
     * @param workbench
     * @param selection
     */
    public void init(final IWorkbench workbench, final IStructuredSelection selection) {
        this.selection = selection;
    }

    /**
     *
     * @return
     */
    public boolean performFinish() {
        // {IɃ`FbN̓EBU[hŏIĂƉ肵܂B
        IProject proj = getProject(selection);
        if (proj == null) {
            return false;
        }

        //  t@CVK쐬܂B
        IFile file = proj.getFile(BlancoCsvPluginConstants.TARGET_FILENAME);
        doFinish(file);

        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            // GfB^J܂B
            IDE.openEditor(page, file, "blanco.plugin.csv.editors");
        } catch (PartInitException e) {
            // O͖܂B
        }

        return true;
    }

    /**
     */
    public void addPages() {
        final AbstractBlancoCsvWizardPage page = new BlancoCsvWizardPage(selection);
        addPage(page);
        final BlancoCsvWizardPage2 page2 = new BlancoCsvWizardPage2(selection);
        addPage(page2);
        final BlancoCsvWizardPage3 page3 = new BlancoCsvWizardPage3(selection);
        addPage(page3);
        final BlancoCsvWizardPage4 page4 = new BlancoCsvWizardPage4(selection);
        addPage(page4);
        final AbstractBlancoCsvWizardPage99 page99 = new BlancoCsvWizardPage99(selection);
        addPage(page99);
    }

    /**
     * ISelection IProject(vWFNg)擾܂B
     *
     * @param selection
     * @return
     */
    public static IProject getProject(final ISelection selection) {
        IProject proj = null;
        IStructuredSelection ssel = (IStructuredSelection) selection;
        if (ssel.isEmpty()) {
            return null;
        }
        Object obj = ssel.getFirstElement();
        if (obj instanceof IProjectNature) {
            // vWFNg̏ꍇɂ́AꂪĂ܂B
            IProjectNature nature = (IProjectNature) obj;
            proj = nature.getProject();
        } else if (obj instanceof IResource) {
            IResource res = (IResource) obj;
            proj = res.getProject();
        } else {
            System.out.println(obj.getClass());
            return null;
        }
        return proj;
    }

    /**
     *
     * @param file
     */
    private void doFinish(final IFile file) {
        try {
            InputStream stream = openContentStream();
            if (file.exists()) {
                // Ȃɂ܂B
            } else {
                file.create(stream, false, null);
            }
            stream.close();
        } catch (IOException e) {
        } catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /**
     *
     * @return
     */
    private InputStream openContentStream() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><blanco/>";
        return new ByteArrayInputStream(contents.getBytes());
    }
}
